% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchSize.R
\name{batchSize}
\alias{batchSize}
\title{Batch size (truncation point) selection}
\usage{
batchSize(x, method = c("bm", "obm", "bartlett", "tukey", "sub"), g = NULL, fast = TRUE)
}
\arguments{
\item{x}{A matrix or data frame of Markov chain output. Number of rows is the Monte
Carlo sample size.}

\item{method}{Any of \dQuote{\code{bm}},\dQuote{\code{obm}},\dQuote{\code{bartlett}},\dQuote{\code{tukey}}. \dQuote{\code{bm}}
represents batch means estimator, \dQuote{\code{obm}} represents the overlapping batch means estimator,
and \dQuote{\code{bartlett}} and \dQuote{\code{tukey}} represent the modified-Bartlett window and
the Tukey-Hanning windows for the spectral variance estimators.}

\item{g}{A function that represents features of interest. \code{g} is applied to each row of x and
thus \code{g} should take a vector input only. If \code{g} is \code{NULL}, \code{g} is set to be identity, which
is estimation of the mean of the target density.}

\item{fast}{Boolean variable for fast estimation using a reasonable subset of the Markov chain.}
}
\value{
A value of the optimal batch size (truncation point or bandwidth) is returned.
}
\description{
Function returns the optimal batch size (or truncation point) for a given chain and method.
}
\details{
\code{batchSize} fits a stationary autoregressive process to the marginals of \code{x}, selecting the order of
the process as the one with the maximum AIC among the models with coefficients greater than a threshold.
}
\examples{

## Bivariate Normal with mean (mu1, mu2) and covariance sigma
n <- 1e3
mu <- c(2, 50)
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)

out <- BVN_Gibbs(n, mu, sigma)

batchSize(out)
batchSize(out, method = "obm")
batchSize(out, method = "bartlett")

}
\references{
Liu, Y., Vats, D., and Flegal, J. M. (2021) Batch size selection for variance estimators in MCMC, \emph{Methodology and
Computing in Applied Probability}, to appear.
}
\seealso{
\code{\link{mcse.multi}} and \code{\link{mcse}}, which calls on \code{batchSize}.
}
