#' Tools for Multivariate Cauchy Distributions
#'
#' This package provides tools for multivariate Cauchy distributions (MCD):
#' \itemize{
#' \item Calculation of distances/divergences between MCD:
#' \itemize{
#' \item Kullback-Leibler divergence: \code{\link{kldcauchy}}
#' }
#' \item Tools for MCD:
#' \itemize{
#' \item Probability density: \code{\link{dmcd}}
#' \item Simulation from a MCD: \code{\link{rmcd}}
#' \item Plot of the density of a MCD with 2 variables: \code{\link{plotmcd}}, \code{\link{contourmcd}}
#' }
#' }
#'
#' @name mcauchyd-package
#' @aliases mcauchyd-package mcauchyd
#' @docType package
#' @author Pierre Santagostini <pierre.santagostini@agrocampus-ouest.fr>,
#' Nizar Bouhlel <nizar.bouhlel@agrocampus-ouest.fr>
#' @references N. Bouhlel, D. Rousseau, A Generic Formula and Some Special Cases for the Kullback–Leibler Divergence between Central Multivariate Cauchy Distributions.
#' Entropy, 24, 838, July 2022.
#' \doi{10.3390/e24060838}
#' 
NULL
