% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfaTMB.R
\name{dfaTMB}
\alias{dfaTMB}
\title{Tim Cline's original code to Fit a DFA model with TMB.}
\usage{
dfaTMB(
  y,
  model = list(m = 1, R = "diagonal and equal"),
  inits = list(R = 0.05),
  EstCovar = FALSE,
  Covars = NULL,
  indivCovar = FALSE,
  Dmat = NULL,
  Dfac = NULL,
  EstSE = FALSE,
  silent = TRUE,
  fun.opt = c("nlminb", "optim", "nlminb+optim"),
  method = c("Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN", "Brent"),
  control = NULL,
  form = c("dfa", "marxss")
)
}
\arguments{
\item{y}{Vector of observations n x T.}

\item{model}{list with
\itemize{
\item R  "diagonal and equal", "unconstrained", "diagonal and unequal"
\item m number of states (x)
}}

\item{inits}{list of initial conditions}

\item{EstCovar}{TRUE/FALSE}

\item{Covars}{An optional matrix, dimensioned nD x T, where nD is the number of covariates}

\item{indivCovar}{flag for structure of covariates}

\item{Dmat}{D initial matrix}

\item{Dfac}{What elements of D are fixed}

\item{EstSE}{TRUE / FALSE, whether to return the Hessian from the TMB sdreport}

\item{silent}{Show TMB output when fitting, defaults to TRUE}

\item{fun.opt}{function to use for optimization: \code{stats::nlminb()} or \code{stats::optim()}}

\item{method}{to pass to optim call; ignored for \code{fun="nlminb"}}

\item{control}{a list with the control settings for the optimatization function. See details for the defaults.}

\item{form}{The equation form used in the marssTMB() call. The default is "dfa".}
}
\value{
A list with Optimization, Estimates, Fits, and AIC
}
\description{
This can be called to fit a DFA with his syntax, but generally no work should be done here.
}
\details{
The control defaults for \code{\link[stats:nlminb]{stats::nlminb()}} are \code{iter.max = 2000} and \code{eval.max = 2000}.
For \code{\link[stats:optim]{stats::optim()}}, the defaults are \code{reltol = 1e-12} and \code{maxit = 2000}.
}
\examples{
library(MARSS)
data(lakeWAplankton, package = "MARSS")
phytoplankton <- c("Cryptomonas", "Diatoms", "Greens", "Unicells", "Other.algae")
dat <- as.data.frame(lakeWAplanktonTrans) |>
  subset(Year >= 1980 & Year <= 1989) |>
  subset(select=phytoplankton) |>
  t() |>
  MARSS::zscore()

#fit with MARSS
m1.em <- MARSS(dat, model=list(R='unconstrained', m=1, tinitx=1), form='dfa', z.score=FALSE)
m1.tmb <- dfaTMB(dat, model=list(R='unconstrained', m=1))
c(m1.em$logLik, m1.tmb$logLik)
}
\author{
Tim Cline wrote most of this while a graduate student in the Fish 507 Time Series Analysis course. Eli Holmes later modified it to replicate the MARSS(x, form="dfa") model.
}
