% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detail.R
\name{detail}
\alias{detail}
\alias{detail.default}
\alias{detail.data.frame}
\title{Details an object}
\usage{
detail(x, ...)

\method{detail}{default}(x, factor_n = 5L, ...)

\method{detail}{data.frame}(x, factor_n = 5L, ...)
}
\arguments{
\item{x}{An object}

\item{...}{Additional arguments passed to methods}

\item{factor_n}{An \code{integer} threshold for making factors; will convert any
character vectors with \code{factor_n} or less unique values into a \code{fact};
setting as \code{NA} will ignore this}
}
\description{
Provides details about an object
}
\examples{
x <- sample(letters[1:4], 10, TRUE)
detail(x)

df <- quick_df(list(
  x = x,
  y = round(runif(10), 2),
  z = Sys.Date() + runif(10) * 100
))

detail(df)
}
