% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_mc.R
\name{do_mc}
\alias{do_mc}
\alias{gen_mc_est}
\title{Monte Carlo Estimates for
'indirect_effects' and
'cond_indirect_effects'}
\usage{
do_mc(
  fit,
  R = 100,
  seed = NULL,
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE
)

gen_mc_est(fit, R = 100, seed = NULL)
}
\arguments{
\item{fit}{The output of
\code{\link[lavaan:sem]{lavaan::sem()}}.
It can also be
a \code{lavaan.mi} object
returned by
\code{\link[semTools:runMI]{semTools::runMI()}} or
its wrapper, such as \code{\link[semTools:runMI]{semTools::sem.mi()}}.
The output of
\code{\link[stats:lm]{stats::lm()}} is not supported.}

\item{R}{The number of replications.
Default is 100.}

\item{seed}{The seed for the
generating Monte Carlo estimates.
Default is \code{NULL} and seed is not set.}

\item{parallel}{Not used. Kept
for compatibility with \code{\link[=do_boot]{do_boot()}}.}

\item{ncores}{Not used. Kept
for compatibility with \code{\link[=do_boot]{do_boot()}}.}

\item{make_cluster_args}{Not used. Kept
for compatibility with \code{\link[=do_boot]{do_boot()}}.}

\item{progress}{Logical. Display
progress or not. Default is \code{TRUE}.}
}
\value{
A \code{mc_out}-class object
that can be used for the \code{mc_out}
argument of
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}} for forming
Monte Carlo confidence intervals. The
object is a list with the number of
elements equal to the number of
Monte Carlo replications. Each element
is a
list of the parameter estimates and
sample variances and covariances of
the variables in each Monte Carlo
replication.
}
\description{
Generate Monte Carlo
estimates to be used by
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}},
}
\details{
It uses the parameter
estimates and their variance-covariance
matrix to generate Monte Carlo
estimates of the parameter estimates
in a model fitted by
\code{\link[lavaan:sem]{lavaan::sem()}}. The stored estimates
can then be used by
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}} to form
Monte Carlo confidence intervals.

It also supports a model estimated
by multiple imputation using
\code{\link[semTools:runMI]{semTools::runMI()}} or its wrapper,
such as \code{\link[semTools:runMI]{semTools::sem.mi()}}.
The pooled estimates and their
variance-covariance matrix will be used
to generate the Monte Carlo estimates.

This approach removes the need to
repeat Monte Carlo simulation in
each call to
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}}. It also ensures
that the same set of Monte Carlo
estimates is used in all subsequent
analysis.
}
\section{Functions}{
\itemize{
\item \code{do_mc()}: A general purpose function for
creating Monte Carlo estimates to be reused
by other functions. It returns a
\code{mc_out}-class object.

\item \code{gen_mc_est()}: Generate Monte Carlo
estimates and store them in the \code{external}
slot: \code{external$manymome$mc}. For advanced
users.

}}
\examples{

library(lavaan)
data(data_med_mod_ab1)
dat <- data_med_mod_ab1
mod <-
"
m ~ x + w + x:w + c1 + c2
y ~ m + w + m:w + x + c1 + c2
"
fit <- sem(mod, dat)
# In real research, R should be 5000 or even 10000
mc_out <- do_mc(fit, R = 100, seed = 1234)
wlevels <- mod_levels(w = "w", fit = fit)
wlevels
out <- cond_indirect_effects(wlevels = wlevels,
                             x = "x",
                             y = "y",
                             m = "m",
                             fit = fit,
                             mc_ci = TRUE,
                             mc_out = mc_out)
out

}
\seealso{
\code{\link[=fit2mc_out]{fit2mc_out()}}, which
implements the Monte Carlo simulation.
}
