% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLData_as.R
\name{as_tibble.LPJmLData}
\alias{as_tibble.LPJmLData}
\title{Coerce an LPJmLData object to a tibble}
\usage{
\method{as_tibble}{LPJmLData}(x, subset = NULL, aggregate = NULL, value_name = "value", ...)
}
\arguments{
\item{x}{\link{LPJmLData} object}

\item{subset}{List of array dimension(s) as name/key and
corresponding subset vector as value, e.g.
\code{list(cell = c(27411:27415))}. More information at
\code{\link[=subset.LPJmLData]{subset.LPJmLData()}}.}

\item{aggregate}{List of array dimension(s) as name/key and
corresponding aggregation function as value, e.g.
\code{list(band = sum)}.}

\item{value_name}{Name of value column in returned \code{tibble}. Defaults to
\code{"value"}.}

\item{...}{Arguments passed to the aggregate function(s), e.g.
\code{na.rm = TRUE}.}
}
\value{
a \link[tibble]{tibble} with columns corresponding to dimension
naming of the \code{LPJmLData$data} array and values in one value column.
}
\description{
Function to coerce (convert) an \code{\link{LPJmLData}} object into a
\link[tibble]{tibble} (modern \link[base]{data.frame}). Read more about
tibbles at \url{https://r4ds.had.co.nz/tibbles.html}.
Please make sure to call \code{lpjmlkit::as_tibble()} explicitly when also using
the tidyverse packages tibble or dplyr.
}
\examples{
\dontrun{

vegc <- read_io(filename = "./vegc.bin.json")

# Returns two-dimensional tibble representation of vegc$data.
as_tibble(vegc)
#   cell  time       band    value
#   <fct> <fct>      <fct>   <dbl>
# 1 0     1901-12-31 1     13627.
# 2 1     1901-12-31 1       120.
# 3 2     1901-12-31 1       133.
# 4 3     1901-12-31 1        97.4
# 5 4     1901-12-31 1        75.9
# 6 5     1901-12-31 1        11.1

}

}
