% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocorr.R
\name{varCor}
\alias{varCor}
\title{Compute the unbiased variance accounting for empirical autocorrelations}
\usage{
varCor(
  x,
  effCor = computeEffectiveAutoCorr(x),
  na.rm = FALSE,
  nEff = computeEffectiveNumObs(x, effAcf = effCor)
)
}
\arguments{
\item{x}{numeric vector}

\item{effCor}{numeric vector of effective correlation components
first entry at zero lag equals one. See \code{\link{computeEffectiveAutoCorr}}
The effective correlation is passed to \code{\link{computeEffectiveNumObs}}.}

\item{na.rm}{logical. Should missing values be removed?}

\item{nEff}{possibility to specify precomputed number of effective 
observations for speedup.}
}
\value{
numeric scalar of unbiased variation of x
}
\description{
Compute the unbiased variance accounting for empirical autocorrelations
}
\details{
The default uses empirical autocorrelation
 estimates from the supplied data up to first negative component.
 For short series of \code{x} it is strongly recommended to to
 provide \code{effCov} that was estimated on a longer time series.
}
