% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logiBin.R
\name{binTest}
\alias{binTest}
\title{Checking the performance of the bins created on test data}
\usage{
binTest(binObj, testDf, y, xVars, nCores = 1)
}
\arguments{
\item{binObj}{- An object returned by getBins or any other function (except createBins) in this package}

\item{testDf}{- A data frame containing the test data}

\item{y}{- The name of the dependent variable}

\item{xVars}{- A vector names of variables which are to be tested}

\item{nCores}{- The number of cores used for parallel processing. The default value is 1}
}
\value{
Returns a list containing 2 elements.
The first is a data frame called varSummary which contains a summary of the performance of the variables on the test data including their IV value, entropy, flag which indicates if bad rate increases/decreases with variable value, flag to indicate if a monotonic trend is present, number of bins which flip (i.e. do not follow a monotonic trend), number of bins of the variable and a flag to indicate whether it includes pure nodes (node which do not have any defaults).
The second element is a data frame called bin which contains details of all the bins of the variables.
}
\description{
This function uses parallel processing to replicate the bins on test data. This can be used to check the stability of the variable.
}
\examples{
b1 <- getBins(loanData, "bad_flag", c('LTV', 'balance'))
b2 <- binTest(b1, loanData[1:50,], "bad_flag", c('LTV', 'balance'))

}
