# Contributing to 'lightparser'

This outlines how to propose a change to 'lightparser'.

## Use of 'fusen' to build the code base and documentation

Package 'fusen' is used to build the code base and documentation of 'lightparser'.  
'fusen' is a package that provides a framework for building R packages from a Rmarkdown file (or Quarto file).
See documentation of 'fusen' for more details: https://thinkr-open.github.io/fusen

## Some tips to contribute with 'fusen'

- Most of modifications can be realized by modifying a 'flat' file in the "dev/" directory.
Then, run `fusen::inflate_all()` to generate the corresponding R, test or vignette files.

- You can see the list of all `active` flat files and the corresponding generated files by opening the "dev/config_fusen.yaml" file. There is one section for each flat file.

- You will see text like `"# WARNING - Generated by 'fusen' from dev/flat_***.Rmd: do not edit by hand"` on the top of all generated R, test or vignette files, when they are actually generated by 'fusen'.
All other file, not generated by 'fusen', should be listed under the `"keep"` section in the "dev/config_fusen.yaml" file. You can run `fusen::check_not_registered_files()` to check if that's the case.

### Modify documentation

- You will find the roxygen skeleton in the corresponding `function` chunk
- Text of the vignette is generally the text between chunk of the flat file

### Modify of a function

We recommend a test driven development approach:

- Write or modify a unit test in the corresponding `test` chunk of the function
- Modify the code of the function in the corresponding `function` chunk
- Run the 'inflate' command at the bottom of the flat file
- Run `devtools::test()` to check if the test is passing

To avoid multiple inflates, you can run the code locally

- Instead of inflating, run `fusen::load_flat_functions()` to load the function of the current flat file in your global environment
- Run your tests line by line from the `test` chunk
- You can also use your favorite debuging tools


## What if I do not understand 'fusen' ?

We are here to help.  
If you know how to modify a package without 'fusen', contribute as you would do normally.
Forget the flat files for a moment. A 'fusen' package is still a classical package if you remove the "dev/" directory. There is no difference.  

Open a Pull Request and we will help you to integrate your contribution in the 'fusen' framework.


## Code of Conduct

Please note that the 'lightparser' project is released with a
[Contributor Code of Conduct](CODE_OF_CONDUCT.md). By contributing to this
project you agree to abide by its terms.
