% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularizedSmoothSEMInternal.R
\name{newTau}
\alias{newTau}
\title{newTau}
\usage{
newTau(regularizedSEM, tau)
}
\arguments{
\item{regularizedSEM}{object fitted with approximate optimization}

\item{tau}{new tau value}
}
\value{
regularizedSEM, but with new regularizedSEM@fits$nonZeroParameters
}
\description{
assign new value to parameter tau used by approximate optimization. Any regularized
value below tau will be evaluated as zeroed which directly impacts the AIC, BIC, etc.
}
\examples{
library(lessSEM)

# Identical to regsem, lessSEM builds on the lavaan
# package for model specification. The first step
# therefore is to implement the model in lavaan.

dataset <- simulateExampleData()

lavaanSyntax <- "
f =~ l1*y1 + l2*y2 + l3*y3 + l4*y4 + l5*y5 +
     l6*y6 + l7*y7 + l8*y8 + l9*y9 + l10*y10 +
     l11*y11 + l12*y12 + l13*y13 + l14*y14 + l15*y15
f ~~ 1*f
"

lavaanModel <- lavaan::sem(lavaanSyntax,
                           data = dataset,
                           meanstructure = TRUE,
                           std.lv = TRUE)

# Regularization:

lsem <- smoothLasso(
  # pass the fitted lavaan model
  lavaanModel = lavaanModel,
  # names of the regularized parameters:
  regularized = paste0("l", 6:15),
  epsilon = 1e-10,
  tau = 1e-4,
  lambdas = seq(0,1,length.out = 50))
newTau(regularizedSEM = lsem, tau = .1)
}
