% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlOptimizer.R
\name{controlBFGS}
\alias{controlBFGS}
\title{controlBFGS}
\usage{
controlBFGS(
  startingValues = "est",
  initialHessian = ifelse(all(startingValues == "est"), "lavaan", "compute"),
  saveDetails = FALSE,
  stepSize = 0.9,
  sigma = 1e-05,
  gamma = 0,
  maxIterOut = 1000,
  maxIterIn = 1000,
  maxIterLine = 500,
  breakOuter = 1e-08,
  breakInner = 1e-10,
  convergenceCriterion = 0,
  verbose = 0,
  nCores = 1
)
}
\arguments{
\item{startingValues}{option to provide initial starting values. Only used for the first lambda. Three options are supported. Setting to "est" will use the estimates
from the lavaan model object. Setting to "start" will use the starting values of the lavaan model. Finally, a labeled vector with parameter
values can be passed to the function which will then be used as starting values.}

\item{initialHessian}{option to provide an initial Hessian to the optimizer. Must have row and column names corresponding to the parameter labels. use getLavaanParameters(lavaanModel) to
see those labels. If set to "gradNorm", the maximum of the gradients at the starting
values times the stepSize will be used. This is adapted from Optim.jl
https://github.com/JuliaNLSolvers/Optim.jl/blob/f43e6084aacf2dabb2b142952acd3fbb0e268439/src/multivariate/solvers/first_order/bfgs.jl#L104
If set to a single value, a diagonal matrix with the single value along the diagonal will be used.
The default is "lavaan" which extracts the Hessian from the lavaanModel. This Hessian
will typically deviate from that of the internal SEM represenation of lessSEM (due to
the transformation of the variances), but works quite well in practice.}

\item{saveDetails}{when set to TRUE, additional details about the individual
models are save. Currently, this are the Hessian and the implied means and covariances.
Note: This may take a lot of memory!}

\item{stepSize}{Initial stepSize of the outer iteration (theta_{k+1} = theta_k + stepSize * Stepdirection)}

\item{sigma}{only relevant when lineSearch = 'GLMNET'. Controls the sigma parameter in Yuan, G.-X., Ho, C.-H., & Lin, C.-J. (2012). An improved GLMNET for l1-regularized logistic regression. The Journal of Machine Learning Research, 13, 1999–2030. https://doi.org/10.1145/2020408.2020421.}

\item{gamma}{Controls the gamma parameter in Yuan, G.-X., Ho, C.-H., & Lin, C.-J. (2012). An improved GLMNET for l1-regularized logistic regression. The Journal of Machine Learning Research, 13, 1999–2030. https://doi.org/10.1145/2020408.2020421. Defaults to 0.}

\item{maxIterOut}{Maximal number of outer iterations}

\item{maxIterIn}{Maximal number of inner iterations}

\item{maxIterLine}{Maximal number of iterations for the line search procedure}

\item{breakOuter}{Stopping criterion for outer iterations}

\item{breakInner}{Stopping criterion for inner iterations}

\item{convergenceCriterion}{which convergence criterion should be used for the outer iterations? possible are 0 = GLMNET, 1 = fitChange, 2 = gradients.
Note that in case of gradients and GLMNET, we divide the gradients (and the Hessian) of the log-Likelihood by N as it would otherwise be
considerably more difficult for larger sample sizes to reach the convergence criteria.}

\item{verbose}{0 prints no additional information, > 0 prints GLMNET iterations}

\item{nCores}{number of core to use. Multi-core support is provided by RcppParallel and only supported for SEM, not for general purpose optimization.}
}
\value{
object of class controlBFGS
}
\description{
Control the BFGS optimizer.
}
\examples{
control <- controlBFGS()
}
