% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{coefs.plot}
\alias{coefs.plot}
\title{Plot Estimation Results}
\usage{
coefs.plot(
  points = NULL,
  bounds = NULL,
  intervals = NULL,
  distributions = NULL,
  newPlot = TRUE,
  xlim = NULL,
  ylim = NULL,
  boundFun = function(b, type) ifelse(type == "xmin" || type == "ymin", 0.9 * b, 1.1 * b),
  legendsTitle = c("Point", "Bound", "Interval", "Density"),
  legendSize = 5,
  ...
)
}
\arguments{
\item{points}{A list where each element is a point estimate to be drawn
as a shape. Each element must also be a list with the following elements:
1.\code{value}: estimated coefficient,
2.\code{y}: vertical position (default=0),
3.\code{pch}: \code{pch} of the point (default="1"), and other usual attributes.}

\item{bounds}{A list where each element is bound estimation information (e.g.
output of an extreme bound analysis) to be drawn as a rectangle. Each element is defined by the following items:
1.\code{xmin}: where bound starts on x-axis,
2.\code{xmax}: where bound ends on x-axis,
3.\code{ymin}: where bound starts on y-axis (default=-0.1),
4.\code{ymax}: where bound ends on y-axis (default=+0.1),
5.\code{alpha}: alpha for \code{rgb} color, and other usual attributes.}

\item{intervals}{A list where each element is interval estimation information. Each element is a
list similar to \code{bounds} but with a value to be drawn at the middle of the interval. In other words,
each element is defined by 1.\code{value}: center of the interval, 2.\code{xmin}: see \code{bound}, 3.\code{xmax}: see \code{bound}, etc.}

\item{distributions}{A list where each element is a distribution estimate to be drawn
by its density function. Each element is defined by a
1.\code{type} which is the name of the distribution. Other elements of the list depend on the type of distribution.
For \code{type=normal}, elements must be 2.\code{mean}, 3.\code{var}, 4.\code{sdMultiplier}. For
\code{type=GLD}, they can be 2.\code{p1},..., 5.\code{p4}, 6.\code{quantiles}. For \code{type==cdfs}
they can be 2.\code{xs}, 3.\code{cdfs}, 4.\code{smoothFun}.}

\item{newPlot}{If \code{TRUE}, initializes a new plot.}

\item{xlim}{Array of size two for x-axis limits. If \code{NULL}, auto-generated.}

\item{ylim}{Array of size two for y-axis limits. If \code{NULL}, auto-generated.}

\item{boundFun}{Function to control \code{xlim} and \code{ylim} in the plot, with arguments being the computed bounds.}

\item{legendsTitle}{List of titles for legends.}

\item{legendSize}{Numeric value for size of legend (width or height) in lines of text (passed to \code{oma}).}

\item{...}{Additional properties for plot or legend, such as \code{xlab} and \code{ylab}.}
}
\value{
This function does not return any value.
}
\description{
This function plots estimated coefficients, which may be point estimates, bounds, intervals, or distributions.
}
\examples{
points <- list()
points$one <- list(value = 1, label = "Point 1")
points$two <- list(value = 2, label = "Point 2", col = "red", pch = 22, cex = 4)
coefs.plot(points = points)

bounds <- list()
bounds$one <- list(xmin = -1, xmax = 0.5, label = "Bound 1")
bounds$two <- list(
  xmin = 0, xmax = 1, ymin = 0.2, ymax = 0.3,
  label = "Bound 2", alpha = 0.2, col = rgb(0, 0, 1.0, alpha = 0.3)
)
coefs.plot(points = points, bounds = bounds)

intervals <- list()
intervals$one <- list(value = 2, xmin = 0, xmax = 3, label = "Interval 1")
intervals$two <- list(
  value = 1.5, xmin = 1, xmax = 2, y = 4,
  label = "Interval 2", col = "blue", lwd = 3, pch = 11, cex = c(1.2, 3, 1.2)
)
coefs.plot(points = points, bounds = bounds, intervals = intervals)

distributions <- list()
distributions$one <- list(type = "normal", mean = 0, var = 1, label = "Distribution 1")
distributions$two <- list(
  type = "gld", p1 = 0, p2 = 1.5, p3 = 1.2,
  p4 = 1.2, label = "Distribution 2", col = "blue", lwd = 3
)
distributions$three <- list(
  type = "cdfs", xs = seq(-2, 2, 0.1),
  cdfs = pnorm(seq(-2, 2, 0.1)), label = "Distribution 3",
  col = rgb(1, 0, 0, alpha = 0.5), lwd = 8
)
coefs.plot(
  points = points, bounds = bounds, intervals = intervals,
  distributions = distributions, legendsTitle = NULL, legendSize = 7
)

}
