% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_cov.R
\name{lavaan_cov}
\alias{lavaan_cov}
\title{Extract relevant covariance indices from lavaan model}
\usage{
lavaan_cov(fit, estimate = "B", nice_table = FALSE, ...)
}
\arguments{
\item{fit}{lavaan fit object to extract covariance indices from}

\item{estimate}{What estimate to use, either the standardized
estimate ("B", default), or unstandardized
estimate ("b").}

\item{nice_table}{Logical, whether to print the table as a
\code{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}

\item{...}{Arguments to be passed to \code{rempsyc::nice_table}}
}
\value{
A dataframe of covariances, including the covaried variables,
the covariance, and corresponding p-value.
}
\description{
Extract relevant covariance indices from lavaan model through
\code{lavaan::parameterEstimates} with \code{standardized = TRUE}. In this
case, the covariances represent the resulting
\code{std.all} column.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
(latent <- list(visual = paste0("x", 1:3),
                textual = paste0("x", 4:6),
                speed = paste0("x", 7:9)))

(regression <- list(ageyr = c("visual", "textual", "speed"),
                    grade = c("visual", "textual", "speed")))

(covariance <- list(speed = "textual", ageyr = "grade"))

HS.model <- write_lavaan(regression = regression, covariance = covariance,
                         latent = latent, label = TRUE)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data=HolzingerSwineford1939)
lavaan_cov(fit)
\dontshow{\}) # examplesIf}
}
\keyword{CFA}
\keyword{analysis}
\keyword{equation}
\keyword{lavaan}
\keyword{modeling}
\keyword{path}
\keyword{structural}
