% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-compare2.R
\name{compare2}
\alias{compare2}
\alias{compare2.lvmfit}
\alias{compare2.lvmfit2}
\alias{compare.lvmfit2}
\title{Test Linear Hypotheses With Small Sample Correction}
\usage{
compare2(
  object,
  linfct,
  rhs,
  robust,
  cluster,
  as.lava,
  F.test,
  conf.level,
  ...
)

\method{compare2}{lvmfit}(
  object,
  linfct = NULL,
  rhs = NULL,
  robust = FALSE,
  cluster = NULL,
  as.lava = TRUE,
  F.test = TRUE,
  conf.level = 0.95,
  ssc = lava.options()$ssc,
  df = lava.options()$df,
  ...
)

\method{compare2}{lvmfit2}(
  object,
  linfct = NULL,
  rhs = NULL,
  robust = FALSE,
  cluster = NULL,
  as.lava = TRUE,
  F.test = TRUE,
  conf.level = 0.95,
  ...
)

\method{compare}{lvmfit2}(
  object,
  linfct = NULL,
  rhs = NULL,
  robust = FALSE,
  cluster = NULL,
  as.lava = TRUE,
  F.test = TRUE,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{linfct}{[matrix or vector of character] the linear hypotheses to be tested. Same as the argument \code{par} of \code{\link{createContrast}}.}

\item{rhs}{[vector] the right hand side of the linear hypotheses to be tested.}

\item{robust}{[logical] should the robust standard errors be used instead of the model based standard errors?}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{as.lava}{[logical] should the output be similar to the one return by \code{lava::compare}?}

\item{F.test}{[logical] should a joint test be performed?}

\item{conf.level}{[numeric 0-1] level of the confidence intervals.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}

\item{df}{[character] method used to estimate the degree of freedoms of the Wald statistic: Satterthwaite \code{"satterthwaite"}. 
Otherwise (\code{"none"}/code{FALSE}/code{NA}) the degree of freedoms are set to \code{Inf}.
Only relevant when using a \code{lvmfit} object.}
}
\value{
If \code{as.lava=TRUE} an object of class \code{htest}.
Otherwise a \code{data.frame} object.
}
\description{
Test Linear Hypotheses using Wald statistics in a latent variable model.
Similar to \code{lava::compare} but with small sample correction.
}
\details{
The \code{linfct} argument and \code{rhs} specify the set of linear hypotheses to be tested. They can be written:
\deqn{
  linfct * \theta = rhs
}
where \eqn{\theta} is the vector of the model coefficients. \cr
The \code{par} argument must contain expression(s) involving the model coefficients.
For example \code{"beta = 0"} or \code{c("-5*beta + alpha = 3","-alpha")} are valid expressions if alpha and beta belong to the set of model coefficients.
A contrast matrix and the right hand side will be generated inside the function. \cr

When directly specified, the contrast matrix must contain as many columns as there are coefficients in the model (mean and variance coefficients).
Each hypothesis correspond to a row in the contrast matrix. \cr

The rhs vector should contain as many elements as there are row in the contrast matrix. \cr
}
\examples{
#### simulate data ####
set.seed(10)
mSim <- lvm(Y~0.1*X1+0.2*X2)
categorical(mSim, labels = c("a","b","c")) <- ~X1
transform(mSim, Id~Y) <- function(x){1:NROW(x)}
df.data <- lava::sim(mSim, 1e2)

#### with lvm ####
m <- lvm(Y~X1+X2)
e.lvm <- estimate(m, df.data)

compare2(e.lvm, linfct = c("Y~X1b","Y~X1c","Y~X2"))
compare2(e.lvm, linfct = c("Y~X1b","Y~X1c","Y~X2"), robust = TRUE)

}
\seealso{
\code{\link{createContrast}} to create contrast matrices. \cr
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{inference}
\keyword{smallSampleCorrection}
