% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_base_data_frame2.R
\name{as_base_data_frame2}
\alias{as_base_data_frame2}
\alias{adf2}
\title{Convert Augmented Data Frame to Base R Data Frame with Alternate Defaults}
\usage{
as_base_data_frame2(data, fact.to.char = TRUE, irreg.to.na = TRUE)

adf2(data, fact.to.char = TRUE, irreg.to.na = TRUE)
}
\arguments{
\item{data}{a data.frame object.}

\item{fact.to.char}{coerce all factor variables to character variables.}

\item{irreg.to.na}{convert all irregular values (see \code{irregular2v()}) to NA.}
}
\value{
a data.frame object with any additional classes removed.
}
\description{
\code{as_base_data_frame2} noisily converts an augmented data.frame to a Base R
data.frame, with any factors converted to character vectors, and any irregular
values (see \code{irregular2()}) converted to NA.
}
\details{
Note: \code{adf2} is a compact alias for \code{as_base_data_frame}: they do the same
thing, and the former is easier to type

\code{as_base_data_frame2} is a variant of \code{as_base_data_frame} with different
default values for fact.to.char and irreg.to.na. Whereas both of these
default to FALSE in \code{as_base_data_frame}, they both default to TRUE in
\code{as_base_data_frame2}. This is the only difference between the two functions.
As such, \code{as_base_data_frame2} is intended as a simple shortcut to save
typing if one prefers to reverse these default logical argument values.
}
\examples{
iris_tib <- tibble::as_tibble(iris)
class(iris_tib)
iris_tib$Sepal.Length[1] <- Inf
head(iris_tib, 1)
iris_df <- as_base_data_frame2(iris_tib)
class(iris_df)
sapply(iris_df, class)
head(iris_df, 1)
}
