% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore_factor_info.R
\name{restore_factor_info}
\alias{restore_factor_info}
\title{Restore Factor Status, Levels to a Character Column of a Labeled Data Frame}
\usage{
restore_factor_info(data)
}
\arguments{
\item{data}{the data.frame to which labelr-specific factor attribute meta-
data may have been applied via \code{add_factor_info}.}
}
\value{
A data.frame.
}
\description{
\code{restore_factor_info} searches a data.frame for labelr-specific factor
meta-data (added by add_factor_info()) and, if found, uses that information
to coerce a character vector that was formerly a factor back into a
factor, with former levels and (if applicable) "ordered" factor status,
as well.
}
\examples{
# this function does not strictly require prior or other use of labelr
zz <- add_factor_info(iris) # we'll find out what this does
sapply(zz, class) # Species is a factor
zz$Species <- as.character(zz) # now it's a character
sapply(zz, class) # yup, it's a character
zz <- restore_factor_info(zz) # we'll find out what this does
sapply(zz, class) # now it's back to a factor
levels(zz$Species) # levels are back, too.
}
