% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quant1.R
\name{add_quant1}
\alias{add_quant1}
\alias{aql1}
\title{Associate Numerical Threshold-based Value Labels with a Single Numerical Variable}
\usage{
add_quant1(data, var, qtiles = NULL, vals = NULL, labs = NULL)

aql1(data, var, qtiles = NULL, vals = NULL, labs = NULL)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the variable to which value labels will be
added.}

\item{qtiles}{the number of quantile categories to employ (e.g., 4 would
indicate quartiles, 5 would indicate quintiles, 10 for deciles, etc.). If
NULL, vals must be non-NULL.}

\item{vals}{one more values of var that will define range cutpoints, such
that all values at or below a given number and above the preceding val will
be treated as part of the same numerical range for labeling purposes. If
NULL, qtiles must be non-NULL.}

\item{labs}{a character vector of distinct labels to identify the
quantiles. If left NULL, convention "q" + quantile (e.g., "q10") will be used
for qtile-based labels (i.e., if qtiles arg is non-NULL), and convention
"<=" + val will be used for vals argument-based labels (i.e., if vals arg is
non-NULL). Note that the labels "NA" and "Other" are (non-case-sensitively)
reserved and may not be user-supplied.}
}
\value{
A data.frame, with new variable value labels added (call
\code{get_val_labs} to see them), other provisional/default labelr label
information added, and previous user-added labelr label information
preserved.
}
\description{
Add variable-specific value labels based on threshold cuts of a single
numerical variable.
}
\details{
\code{add_quant1} is a variant of \code{add_quant_labs} that allows you to specify only
one var to label but allows you to pass its name without quoting it (compare
\code{add_quant1}(mtcars, mpg) to \code{add_quant_labs}(mtcars, "mpg").

Numerical variables that feature decimals or large numbers of distinct values
are not eligible to receive conventional value labels. \code{add_quant1} allows
one to label such variables according to user-supplied value thresholds
(i.e., cutpoints) OR quantile membership, Thus, unlike value labels added
with \code{add_val_labs} (and \code{add_val1}), \code{add_quant1} (and \code{add_quant_labs})
will apply the same value label to all values that fall within the numerical
value range defined by each threshold (cutpoint). For still another
value-labeling approach, see \code{add_m1_lab} (and \code{add1m1}).

Note 1: Quantity labels cannot be added incrementally through repeated calls
to \code{add_quant1}: each new call will overwrite all value labels applied to
the specified vars in any previous \code{add_quant1} calls. This is in contrast to
\code{add_val_labs} (which allows for incremental value-labeling) and \code{add_m1_lab}
(which requires incremental value-labeling).

Note 2: \code{aql1} is a compact alias for \code{add_quant1}: they do the same thing, and
the former is easier to type

Note 3: This command is intended exclusively for interactive use. In
particular, the var argument must be the literal name of a single variable
(column) found in the supplied data.frame and may NOT be, e.g., the name of a
character vector that contains the variable (column name) of interest. If you
wish to supply a character vector with the names of variables (columns) of
interest, use \code{add_quant_labs()}.
}
\examples{
# mtcars demo
df <- mtcars
# now, add value labels
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

# label variable "mpg" in terms of 5 quintiles
df <- add_quant1(data = df, mpg, qtiles = 5)

# label variable "disp" in terms of "pretty" cutpoints
vals2use <- pretty(c(min(df$disp), max(df$disp)))[-1] # establish cutpoints
df <- add_quant1(data = df, disp, vals = vals2use)
df_labson <- use_val_labs(df)
head(df_labson)
}
