% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klsh.R
\name{bag_of_word_ify}
\alias{bag_of_word_ify}
\title{Function to convert a record into a bag of tokens with a fieldwise flag}
\usage{
bag_of_word_ify(record, k, fieldwise = FALSE)
}
\arguments{
\item{record}{String or record}

\item{k}{Parameter k, which is the number of shingle, tokens, or grams to break the string into}

\item{fieldwise}{Flag where the defalt setting to include the record as the entire string}
}
\value{
Computes the bag of tokens for a string
}
\description{
Function to convert a record into a bag of tokens with a fieldwise flag
}
\examples{
data(RLdata500)
data.500 <- RLdata500[-c(2,4)]
bag_of_word_ify(data.500[1,c(-2)],k=2)
bag_of_word_ify(data.500[300,c(-2)],k=2)
names(bag_of_word_ify(data.500[300,c(-2)],k=2))
}
