% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/khazardcond.R
\name{khazardcond}
\alias{khazardcond}
\title{Kernel estimate of conditional hazard function for right-censored data}
\usage{
khazardcond(times, delta, covariate, h = NULL, t = NULL, x = NULL,
  tx = NULL, t.length = 100, x.length = 100, tmin = NULL,
  tmax = NULL, xmin = NULL, xmax = NULL, kernel = "epanechnikov",
  type = "interior", type.w = "nw", parallel = FALSE,
  h.method = "crossval", optim.method = "ga", tol = ifelse(h.method
  == "crossval", 10^(-6), 1), run = 2, ...)
}
\arguments{
\item{times}{vector of observed times}

\item{delta}{vector of censoring indicator. 0 - censored, 1 - uncensored (dead)}

\item{covariate}{vector of covariate}

\item{h}{bandwidth vector of length 2, first element is bandwidth for time and second for covariate. If missing, h is found using some bandwidth selection method.}

\item{t}{vector of time points at which estimate is evaluated}

\item{x}{vector of covariate points at which estimate is evaluated}

\item{tx}{data frame of t and x at which estimate is evaluated}

\item{t.length}{number of grid points of time}

\item{x.length}{number of grid points of covariate}

\item{tmin, tmax}{minimum/maximum values for grid of time}

\item{xmin, xmax}{minimum/maximum values for grid of covariate}

\item{kernel}{kernel function, possible values are: "epanechnikov" (default), "gaussian", "rectangular", "quartic".}

\item{type}{Type of kernel estimate. Possible types are:  "exterior", "interior" (default).}

\item{type.w}{Type of weights. Default are Nadaraya-Watson weights.}

\item{parallel}{allows parallel computation. Default is FALSE.}

\item{h.method}{method for bandwidth selection. Possible methods are: "crossval" (default), "maxlike".}

\item{optim.method}{method for numerical optimization of the crossvalidation or log-likelihood function. Possible methods are: "ga"(default).}

\item{tol}{the desired accuracy of optimization algorithm}

\item{run}{the number of consecutive generations without any improvement in the best fitness value before the GA is stopped.}

\item{...}{additional arguments of GA algorithm}
}
\value{
Returns an object of class 'khazardcond' which is a list with fields
\item{time.points}{vector of time points at which estimate is evaluated}
\item{covariate.points}{vector of covariate points at which estimate is evaluated}
\item{hazard}{matrix of hazard function values on grid or data.frame of time and covariate points and appropriate hazard values if hx is defined}
\item{h}{bandwidth vector}
\item{CVML}{value of crossvalidation or log-likelihood at h}
\item{details}{description of used methods}
\item{GA.result}{output of ga, object of class ga-class}
}
\description{
Kernel estimate of conditional hazard function for right-censored data with one covariate. Options include two methods for bandwidth selection.
}
\details{
External type of kernel estimator is defined as the ratio of kernel estimator of the conditional subdensity of the uncensored observations to the conditional survival function of the observable time. Internal type of kernel estimator is based on a convolution of the kernel function with a nonparametric estimator of the cumulative conditional hazard function.
}
\examples{
library(survival)
fit<-khazardcond(times = lung$time,delta = lung$status-1,covariate = lung$age,h=c(200,20))
}
\references{
Selingerova, I., Dolezelova, H., Horova, I., Katina, S., and Zelinka, J. (2016). Survival of Patients with Primary Brain Tumors: Comparison of Two Statistical Approaches. PloS one, 11(2), e0148733.
}
\seealso{
\code{\link{plot.khazardcond}}, \code{\link[GA]{ga}}
}
