% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ExplicitRepresentation}
\alias{ExplicitRepresentation}
\alias{ExplicitRepresentation-class}
\alias{ExplicitRepresentationDense}
\alias{ExplicitRepresentationDense-class}
\alias{ExplicitRepresentationSparse}
\alias{ExplicitRepresentationSparse-class}
\alias{class:ExplicitRepresentation}
\alias{class:ExplicitRepresentationDense}
\alias{class:ExplicitRepresentationSparse}
\title{Explicit Representation Dense and Sparse Classes}
\description{
Explicit Representation Dense and Sparse Classes
}
\details{
In KeBABS this class is the virtual parent class for explicit representations
generated from a set of biological sequences for a given kernel. The derived
classes \code{\linkS4class{ExplicitRepresentationDense}} and
\code{\linkS4class{ExplicitRepresentationSparse}} are meant to hold explicit
representations in dense or sparse format. The kernel used to generate the
explicit representation is stored together with the data.

Instances of this class are used for storing explicit representations
in dense matrix format. This class is derived from
\code{\linkS4class{ExplicitRepresentation}}.

Instances of this class are used for storing explicit representations
in sparse \code{\linkS4class{dgRMatrix}} format. This class is derived from
\code{\linkS4class{ExplicitRepresentation}}.
}
\section{Slots}{

\describe{
\item{\code{usedKernel}}{kernel used for generating the explicit representation}

\item{\code{quadratic}}{boolean indicating a quadratic explicit representation}
}}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

