% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/access-methods.R, R/coerce-methods.R
\docType{methods}
\name{KernelMatrixAccessors}
\alias{KernelMatrixAccessors}
\alias{[,KernelMatrix,index,index,ANY-method}
\alias{[,KernelMatrix,index,missing,ANY-method}
\alias{[,KernelMatrix,missing,index,ANY-method}
\alias{as.KernelMatrix}
\alias{as.KernelMatrix,matrix-method}
\title{KernelMatrix Accessors}
\usage{
\S4method{[}{KernelMatrix,index,missing,ANY}(x, i)

\S4method{as.KernelMatrix}{matrix}(x, center = FALSE)
}
\arguments{
\item{x}{kernel matrix of class \code{\link{KernelMatrix}}}

\item{i}{numeric vector with indicies or character with element names}

\item{center}{when set to \code{TRUE} the matrix is centered. Default=FALSE}
}
\value{
see above
}
\description{
KernelMatrix Accessors
}
\section{Accessor-like methods}{


\describe{
  \item{\code{x[i, ]}}{
  return as \code{KernelMatrix} object that only contains the rows selected
  with the subsetting parameter i. This parameter can be a numeric vector
  with indices or a character vector which is matched against the names of
  \code{x}.
  }
  \item{\code{x[, j]}}{
  return a \code{KernelMatrix} object that only contains the columns selected
  with the subsetting parameter j. This parameter can be a numeric vector
  with indices or a character vector which is matched against the names of
  \code{x}.
  }
  \item{\code{x[i, j]}}{
  return a \code{KernelMatrix} object that only contains the rows selected
  with the subsetting parameter i and columns selected by j. Both parameters
  can be a numeric vector with indices or a character vector which is matched
  against the names of \code{x}.
  }
}
}

\section{Coercion methods}{

In the code snippets below, \code{x} is a kernel matrix.

\describe{
  \item{\code{as.KernelMatrix(x, center=FALSE)}}{
  centers the kernel matrix dependent on the center parameter and coerce
  it to class \code{\linkS4class{KernelMatrix}} .
  }
}
}
\examples{
## create kernel object for normalized spectrum kernel
specK5 <- spectrumKernel(k=5)
\dontrun{
## load data
data(TFBS)

km <- specK5(enhancerFB)
km1to5 <- km[1:5,1:5]
km1to5
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

