% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/access-methods.R, R/svmModel.R
\docType{methods}
\name{KBModelAccessors}
\alias{KBModelAccessors}
\alias{SVindex}
\alias{SVindex,KBModel-method}
\alias{SVindex<-}
\alias{SVindex<-,KBModel-method}
\alias{cvResult}
\alias{cvResult,KBModel-method}
\alias{cvResult<-}
\alias{cvResult<-,KBModel-method}
\alias{featureWeights}
\alias{featureWeights,KBModel-method}
\alias{featureWeights<-}
\alias{featureWeights<-,KBModel-method}
\alias{getSVMSlotValue}
\alias{modelOffset}
\alias{modelOffset,KBModel-method}
\alias{modelOffset<-}
\alias{modelOffset<-,KBModel-method}
\alias{modelSelResult}
\alias{modelSelResult,KBModel-method}
\alias{modelSelResult<-}
\alias{modelSelResult<-,KBModel-method}
\alias{probabilityModel}
\alias{probabilityModel,KBModel-method}
\alias{probabilityModel<-}
\alias{probabilityModel<-,KBModel-method}
\alias{svmModel}
\alias{svmModel,KBModel-method}
\alias{svmModel<-}
\alias{svmModel<-,KBModel-method}
\title{KBModel Accessors}
\usage{
\S4method{modelOffset}{KBModel}(object)

getSVMSlotValue(paramName, model, raw = FALSE)
}
\arguments{
\item{object}{a KeBABS model}

\item{paramName}{unified name of an SVM model data element}

\item{model}{a KeBABS model}

\item{raw}{when set to \code{TRUE} the parameter value is delivered in
exactly the way as it is stored in the SVM specific model, when
set to \code{FALSE} it is delivered in unified format}
}
\value{
\code{getSVMSlotValue}:
value of requested parameter in unified or native format dependent on
parameter \code{raw}.
}
\description{
KBModel Accessors
}
\section{Accessor-like methods}{

  In all descriptions below, \code{object} is an object of class
  \code{\linkS4class{KBModel}}.

\describe{
  \item{\code{modelOffset(object)}}{
  returns the model offset.
  }
  \item{\code{featureWeights(object)}}{
  returns the feature weights.
  }
  \item{\code{SVindex(object)}}{
  returns the support vector indices for the training samples.
  }
  \item{\code{cvResult(object)}}{
  returns result of cross validation as object of class
  \code{\linkS4class{CrossValidationResult}}.
  }
  \item{\code{modelSelResult(object)}}{
  returns result of model selection as object of class
  \code{\linkS4class{ModelSelectionResult}}.
  }
  \item{\code{svmModel(object)}}{
  returns the native svm model stored within KeBABS model.
  }
  \item{\code{probabilityModel(object)}}{
  returns the probability model stored within KeBABS model.
  }
}
}
\examples{
## create kernel object for normalized spectrum kernel
specK5 <- spectrumKernel(k=5)
\dontrun{
## load data
data(TFBS)

## perform training - feature weights are computed by default
model <- kbsvm(enhancerFB, yFB, specK5, pkg="LiblineaR",
               svm="C-svc", cost=15, cross=10, showProgress=TRUE)
               showProgress=TRUE)

## show result of validation
cvResult(model)
## show feature weights
featureWeights(model)[1:5]
## show model offset
modelOffset(model)
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

