% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.R
\name{genRandBioSeqs}
\alias{genRandBioSeqs}
\title{Generate Random Biological Sequences}
\usage{
genRandBioSeqs(seqType = c("DNA", "RNA", "AA"), numSequences, seqLength,
  biostring = TRUE, seed)
}
\arguments{
\item{seqType}{defines the type of sequence as DNA, RNA or AA and the
underlying alphabet. Default="DNA"}

\item{numSequences}{single numeric value which specifies the number of
sequences that should be generated.}

\item{seqLength}{either a single numeric value or a numeric vector of length
'numSequences' which gives the length of the sequences to be generated.}

\item{biostring}{if \code{TRUE} the sequences will be generated in XStringSet
format otherwise as BioVector derived class. Default=TRUE}

\item{seed}{when present the random generator will be seeded with the
value passed in this parameter}
}
\value{
When the parameter 'biostring' is set to FALSE the function returns a
XStringSet derived class otherwise a BioVector derived class.
}
\description{
Generate biological sequences with uniform random distribution
of alphabet characters.
}
\details{
The function generates a set of sequences with uniform distribution of
alphabet characters and returns it as XStringSet or BioVector dependent on
the parameter \code{biostring}.
}
\examples{
## generate a set of AA sequences of fixed length as AAStringSet
aaseqs <- genRandBioSeqs("AA", 100, 1000, biostring=TRUE)

## show AA sequence set
aaseqs

\dontrun{
## generate a set of "DNA" sequences as DNAStringSet with uniformly
## distributed lengths between 1500 and 3000 bases
seqLength <- runif(300, min=1500, max=3500)
dnaseqs <- genRandBioSeqs("DNA", 100, seqLength, biostring=TRUE)

## show DNA sequence set
dnaseqs
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
\keyword{methods}

