% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/access-methods.R
\docType{methods}
\name{ROCDataAccessors}
\alias{ROCDataAccessors}
\alias{auc}
\alias{auc,ROCData-method}
\alias{auc<-}
\alias{auc<-,ROCData-method}
\alias{fpr}
\alias{fpr,ROCData-method}
\alias{fpr<-}
\alias{fpr<-,ROCData-method}
\alias{tpr}
\alias{tpr,ROCData-method}
\alias{tpr<-}
\alias{tpr<-,ROCData-method}
\title{ROCData Accessors}
\usage{
\S4method{auc}{ROCData}(object)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{ROCData}}}
}
\value{
\code{auc}: returns a numeric value\cr
\code{tpr}: returns a numeric vector\cr
\code{fpr}: returns a numeric vector\cr
}
\description{
ROCData Accessors
}
\section{Accessor-like methods}{


\describe{
  \item{}{\code{auc}:
  returns the area under the ROC curve.
  }
  \item{}{\code{tpr}:
  returns the true positive rate values as numeric vector.
  }
  \item{}{\code{fpr}:
  returns the false positive rate values as numeric vector.
  }
}
}
\examples{
## create kernel object for normalized spectrum kernel
specK5 <- spectrumKernel(k=5)
\dontrun{
## load data
data(TFBS)

## select 70\% of the samples for training and the rest for test
train <- sample(1:length(enhancerFB), length(enhancerFB) * 0.7)
test <- c(1:length(enhancerFB))[-train]

## perform training - feature weights are computed by default
model <- kbsvm(enhancerFB[train], yFB[train], specK5, pkg="LiblineaR",
               svm="C-svc", cost=15)
preddec <- predict(model, enhancerFB[test], predictionType="decision")
rocdata <- computeROCandAUC(preddec, yFB[test], allLabels=unique(yFB))

## accessor for auc
auc(rocdata)
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

