% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weiplot.R
\name{weiplot}
\alias{weiplot}
\title{Create Weibull Plot.}
\usage{
weiplot(data, n = 70, type = "p", xlim = NULL, ylim = c(0.01, 10),
  main = "Weibull Plot", sub = NULL, ylab = "log(1/1-F(x))",
  ylab2 = "F(x)", xlab = "x", percent = "False")
}
\arguments{
\item{data}{data values from which a cumulative density function will be
estimated using \code{ecdf(data)}}

\item{n}{number of points required in plot (default n = 70).}

\item{type}{plot type}

\item{xlim}{the minimum and maximum to be used for the x-axis}

\item{ylim}{the minimum and maximum to be used for the y-axis}

\item{main}{the title of the plot}

\item{sub}{the sub-title of the plot}

\item{ylab}{the title of the left y-axis}

\item{ylab2}{the title of the right y-axis}

\item{xlab}{the title of the x-axis}

\item{percent}{logical; display right hand axis as percentages}
}
\description{
A special type of plot where Weibull distributed data plots as a straight
line. This was also originally called Rayleigh paper. Both Rayleigh and
exponential distributions also plot as straight lines.
}
\details{
A Weibull plot uses log paper and has log(1/(1-F(x)) versus x,
        where the data values x have an empirical cdf of F(x). The plot
        margins may need to be adjusted so that the right hand axis is
        visible.
}
\examples{

graphics::par(mar = c(5, 5, 5, 5))
r <- rexp(100000)
weiplot(r, xlim = c(1e-3, 10))
x <- 10^seq(-3, 2, length = 100)
weilines(x, pexp(x))
}
\seealso{
\code{weilines()} adds lines to a Weibull plot
}

