% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{envelope}
\alias{envelope}
\title{Envelope plot}
\usage{
envelope(
  df,
  p = NULL,
  x = NA,
  row = NULL,
  column = NULL,
  median = TRUE,
  ci = c(0.5, 0.95),
  col = 4,
  add = FALSE,
  dark = 0.3,
  outline = FALSE,
  xlab = "",
  ylab = "",
  main = NULL,
  ylim = NULL,
  transform = c("none", "exp", "expit"),
  ...
)
}
\arguments{
\item{df}{Output object returned from \code{jagsUI::jags()}; or alternately,
two-dimensional \code{data.frame} or matrix in which parameter node element is
given by column and MCMC iteration is given by row.}

\item{p}{Parameter name, if input to \code{df} is a \code{jagsUI} output object.}

\item{x}{Vector of X-coordinates for plotting.}

\item{row}{Row to subset, in the case of a 2-d matrix of parameter nodes in-model.}

\item{column}{Column to subset, in the case of a 2-d matrix of parameter nodes in-model.}

\item{median}{Whether to include median line}

\item{ci}{Vector of intervals to overlay.  Defaults to 50 percent and 95 percent.}

\item{col}{Color for plotting}

\item{add}{Whether to add to existing plot}

\item{dark}{Opacity (0-1) for envelopes.  Note that multiple overlapping intervals will darken the envelope.}

\item{outline}{Whether to just envelope outlines}

\item{xlab}{X-axis label}

\item{ylab}{Y-axis label}

\item{main}{Plot title.  If the default (\code{NULL}) is accepted and argument p is used, p will be used for the title.}

\item{ylim}{Y-axis limits for plotting.  If the default (\code{NULL}) is accepted, these will be determined automatically.}

\item{transform}{Should the y-axis be (back)transformed?  Options are \code{"exp"},
indicating exponential, or \code{"expit"}, indicating inverse-logit. Defaults to
\code{"none"}, indicating no transformation.  Note: if \code{transform="exp"}is used, consider
adding additional plotting argument \code{log="y"}.}

\item{...}{additional plotting arguments or arguments to \code{lines()}}
}
\value{
\code{NULL}
}
\description{
Envelope plot of the posterior densities of a vector of parameter nodes,
in which the sequential order of nodes is important, such as a time series.

This produces a plot of overlayed shaded strips, each corresponding to a given
interval width (defaults to 50 percent and 95 percent), with an overlayed
median line.
}
\examples{
## usage with input data.frame
trend <- jags_df(SS_out, p="trend")
envelope(trend, x=SS_data$x)

## usage with jagsUI object
envelope(SS_out, p="trend")

## usage with 2-d jagsUI object
envelope(SS_out, p="cycle_s", column=1, main="cycle")
envelope(SS_out, p="cycle_s", column=2, col=2, add=TRUE)  ## overlay

## scale transformation
envelope(SS_out, p="trend", transform="exp", ylab="exp transform")
envelope(SS_out, p="trend", transform="exp", ylab="exp transform", log="y")
}
\seealso{
\link{overlayenvelope}, \link{caterpillar}
}
\author{
Matt Tyers
}
