% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{comparepriors}
\alias{comparepriors}
\title{Compare Priors}
\usage{
comparepriors(x, parmfrow = NULL, ...)
}
\arguments{
\item{x}{Output object returned from jagsUI::jags()}

\item{parmfrow}{Optional call to \code{par(mfrow)} for the number of rows & columns of plot window.  Returns the graphics device to previous state afterward.}

\item{...}{additional arguments to \link{comparedens}}
}
\value{
\code{NULL}
}
\description{
Side-by-side kernel density plots for all parameters with parameter
names ending in \code{"_prior"}, and corresponding parameters without.  It should
be noted that these parameters must be specified in JAGS as well as the
corresponding parameters, and this is left to the user.

This function is a wrapper of \link{comparedens}.

Kernel densities are plotted vertically, either left- or right-facing.  Parameters with the same name are
plotted facing one another.
}
\examples{
## a look at what parameters exist in the input object
nbyname(asdf_prior_jags_out)

## then, showing the function usage
comparepriors(asdf_prior_jags_out, parmfrow=c(2, 3))
}
\seealso{
\link{comparecat}, \link{comparedens}, \link{plotdens}
}
\author{
Matt Tyers
}
