% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{trace_df}
\alias{trace_df}
\title{Trace plot of each column of a \code{data.frame}.}
\usage{
trace_df(df, nline, parmfrow = NULL, ...)
}
\arguments{
\item{df}{Posterior data.frame}

\item{nline}{Number of chains}

\item{parmfrow}{Optional call to \code{par(mfrow)} for the number of rows & columns of plot window.  Returns the graphics device to previous state afterward.}

\item{...}{additional plotting arguments or arguments to \code{trace_line()}}
}
\value{
\code{NULL}
}
\description{
Trace plot of each column of a posterior 'data.frame'.
}
\examples{
out_df <- jags_df(asdf_jags_out)

b1 <- pull_post(out_df,"b1")
a <- pull_post(out_df,"a")

trace_df(a, nline=3, parmfrow=c(3,1))

trace_df(a, nline=3, parmfrow=c(3,1))
}
\seealso{
\link{tracedens_jags}, \link{trace_jags}, \link{trace_line}
}
\author{
Matt Tyers
}
