% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icount.R
\name{idiv}
\alias{idiv}
\title{Dividing Iterator}
\usage{
idiv(count, ..., recycle = FALSE, chunkSize, chunks)
}
\arguments{
\item{count}{The total}

\item{...}{Unused.}

\item{recycle}{Whether to restart the count after finishing.}

\item{chunkSize}{the maximum size of the pieces that \code{n} should be
divided into.  This is useful when you know the size of the pieces that you
want.  If specified, then \code{chunks} should not be.}

\item{chunks}{the number of pieces that \code{n} should be divided into.
This is useful when you know the number of pieces that you want.  If
specified, then \code{chunkSize} should not be.}
}
\value{
The dividing iterator.
}
\description{
Returns an iterator dividing a value into integer chunks, such that
\code{sum(idiv(n, ...)) == floor(n)}
}
\details{
Originally from the \code{iterators} package.
}
\examples{

# divide the value 10 into 3 pieces
it <- idiv(10, chunks = 3)
nextOr(it)
nextOr(it)
nextOr(it)
nextOr(it, NULL)  # expect NULL

# divide the value 10 into pieces no larger than 3
it <- idiv(10, chunkSize = 3)
nextOr(it)
nextOr(it)
nextOr(it)
nextOr(it)
nextOr(it, NULL)  # end of iterator

}
