% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islice.R
\name{i_slice}
\alias{i_slice}
\title{Iteror that returns selected elements from an iterable.}
\usage{
i_slice(object, start = 1, end = NULL, step = 1, ...)
}
\arguments{
\item{object}{iterable object through which this function iterates}

\item{start}{the index of the first element to return from \code{object}}

\item{end}{the index of the last element to return from \code{object}}

\item{step}{the step size of the sequence}

\item{...}{passed along to \code{iteror(object, ...)}}
}
\value{
iteror that returns \code{object} in sequence
}
\description{
Constructs an iteror that returns elements from an iterable following the
given sequence with starting value \code{start} and ending value \code{end}.
The sequence's step size is given by \code{step}.
}
\details{
The iterable given in \code{object} is traversed beginning with element
having index specified in \code{start}. If \code{start} is greater than 1,
then elements from the \code{object} are skipped until \code{start} is
reached. By default, elements are returned consecutively. However, if the
\code{step} size is greater than 1, elements in \code{object} are skipped.

If \code{stop} is \code{Inf} (default), the iteration continues until the
iteror is exhausted unless \code{end} is specified. In this case,
\code{end} specifies the sequence position to stop iteration.

Originally from package \code{itertools2}.
}
\examples{
it <- i_slice(1:5, start=2)
nextOr(it, NULL) # 2
nextOr(it, NULL) # 3
nextOr(it, NULL) # 4
nextOr(it, NULL) # 5

it2 <- i_slice(1:10, start=2, end=5)
unlist(as.list(it2)) == 2:5

it3 <- i_slice(1:10, start=2, end=9, step=2)
unlist(as.list(it3)) == c(2, 4, 6, 8)
}
