% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_package_model.R
\name{stan_package_model}
\alias{stan_package_model}
\title{Get a pre-compiled Stan model built into an R package.}
\usage{
stan_package_model(
  name,
  package,
  library = NULL,
  cmdstan_install = Sys.getenv("CMDSTAN_INSTALL")
)
}
\arguments{
\item{name}{Character of length 1, base name of the Stan model file
(without the containing directory or \code{.stan} file extension).}

\item{package}{Character of length 1, name of the R package to look
for the built-in Stan model.}

\item{library}{Character of length 1 or \code{NULL}, library path
to look for the package with the built-in Stan model.
Passed to the \code{lib.loc} argument of \code{system.file()}.}

\item{cmdstan_install}{Character of length 1, how CmdStan was installed. The
installation method determines how \code{instantiate} looks up CmdStan.
Set the default value with the \code{CMDSTAN_INSTALL} environment variable.
Choices:
\enumerate{
\item \code{"internal"}: Use the copy of CmdStan installed internally inside the
\code{instantiate} package file system. Before using this option,
CmdStan must be installed in the package file system. To do this,
set the \code{CMDSTAN_INSTALL} environment variable to \code{"internal"} before
installing \code{instantiate}.
\item \code{"fixed"}: Use the copy of CmdStan that was located at the value
contained in \code{Sys.getenv("CMDSTAN")} at the time \code{instantiate}
was installed. In this case, the path to CmdStan is not inside
\code{instantiate} itself, but it is fixed at installation time
and does not depend on the current value of
\code{Sys.getenv("CMDSTAN")} at runtime.
\item \code{"cmdstanr"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. The \code{cmdstanr} package must be installed. If it
is not installed, the function returns the empty string \code{""}.
\item \code{""} (default): Try all 3 options in the order above to find a valid
installed copy of CmdStan.
}}
}
\value{
An \code{R6} Stan model object from the \code{cmdstanr} package.
Please visit the documentation website at \url{https://mc-stan.org/cmdstanr/}
for detailed information on the composition of this model object
and how to use it to conduct Bayesian inference.
}
\description{
Get the \code{cmdstanr} model object for a pre-compiled Stan
model inside a package.
}
\details{
Packages configured with \code{instantiate} compile their Stan
models on installation. Then the \code{stan_package_model()} function
retrieves the \code{cmdstanr::cmdstan_model()} object without needing
to re-compile the model. Please see the documentation website
of the \code{instantiate} package for examples.
}
\examples{
# Please see the documentation website of the {instantiate} package
#   for examples.
}
\keyword{packages}
