% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_info.R
\name{model_info}
\alias{model_info}
\alias{model_info.default}
\title{Access information from model objects}
\usage{
model_info(x, ...)

\method{model_info}{default}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{verbose}{Toggle off warnings.}
}
\value{
A list with information about the model, like family, link-function
etc. (see 'Details').
}
\description{
Retrieve information from model objects.
}
\details{
\code{model_info()} returns a list with information about the
model for many different model objects. Following information
is returned, where all values starting with \code{is_} are logicals.
\itemize{
\item \code{is_binomial}: family is binomial (but not negative binomial)
\item \code{is_bernoulli}: special case of binomial models: family is Bernoulli
\item \code{is_poisson}: family is poisson
\item \code{is_negbin}: family is negative binomial
\item \code{is_count}: model is a count model (i.e. family is either poisson or negative binomial)
\item \code{is_beta}: family is beta
\item \code{is_betabinomial}: family is beta-binomial
\item \code{is_orderedbeta}: family is ordered beta
\item \code{is_dirichlet}: family is dirichlet
\item \code{is_exponential}: family is exponential (e.g. Gamma or Weibull)
\item \code{is_logit}: model has logit link
\item \code{is_probit}: model has probit link
\item \code{is_linear}: family is gaussian
\item \code{is_tweedie}: family is tweedie
\item \code{is_ordinal}: family is ordinal or cumulative link
\item \code{is_cumulative}: family is ordinal or cumulative link
\item \code{is_multinomial}: family is multinomial or categorical link
\item \code{is_categorical}: family is categorical link
\item \code{is_censored}: model is a censored model (has a censored response, including survival models)
\item \code{is_truncated}: model is a truncated model (has a truncated response)
\item \code{is_survival}: model is a survival model
\item \code{is_zero_inflated}: model has zero-inflation component
\item \code{is_hurdle}: model has zero-inflation component and is a hurdle-model (truncated family distribution)
\item \code{is_dispersion}: model has dispersion component (not only dispersion \emph{parameter})
\item \code{is_mixed}: model is a mixed effects model (with random effects)
\item \code{is_multivariate}: model is a multivariate response model (currently only works for \emph{brmsfit} objects)
\item \code{is_trial}: model response contains additional information about the trials
\item \code{is_bayesian}: model is a Bayesian model
\item \code{is_gam}: model is a generalized additive model
\item \code{is_anova}: model is an Anova object
\item \code{is_ttest}: model is an an object of class \code{htest}, returned by \code{t.test()}
\item \code{is_correlation}: model is an an object of class \code{htest}, returned by \code{cor.test()}
\item \code{is_ranktest}: model is an an object of class \code{htest}, returned by \code{cor.test()}
(if Spearman's rank correlation), \code{wilcox.text()} or \code{kruskal.test()}.
\item \code{is_variancetest}: model is an an object of class \code{htest}, returned by
\code{bartlett.test()}, \code{shapiro.test()} or \code{car::leveneTest()}.
\item \code{is_levenetest}: model is an an object of class \code{anova}, returned by \code{car::leveneTest()}.
\item \code{is_onewaytest}: model is an an object of class \code{htest}, returned by \code{oneway.test()}
\item \code{is_proptest}: model is an an object of class \code{htest}, returned by \code{prop.test()}
\item \code{is_binomtest}: model is an an object of class \code{htest}, returned by \code{binom.test()}
\item \code{is_chi2test}: model is an an object of class \code{htest}, returned by \code{chisq.test()}
\item \code{is_xtab}: model is an an object of class \code{htest} or \code{BFBayesFactor}, and
test-statistic stems from a contingency table (i.e. \code{chisq.test()} or
\code{BayesFactor::contingencyTableBF()}).
\item \code{link_function}: the link-function
\item \code{family}: name of the distributional family of the model. For some
exceptions (like some \code{htest} objects), can also be the name of the test.
\item \code{n_obs}: number of observations
\item \code{n_grouplevels}: for mixed models, returns names and numbers of random effect groups
}
}
\examples{
ldose <- rep(0:5, 2)
numdead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
sex <- factor(rep(c("M", "F"), c(6, 6)))
SF <- cbind(numdead, numalive = 20 - numdead)
dat <- data.frame(ldose, sex, SF, stringsAsFactors = FALSE)
m <- glm(SF ~ sex * ldose, family = binomial)

# logistic regression
model_info(m)

# t-test
m <- t.test(1:10, y = c(7:20))
model_info(m)
}
