#' Earthquake data
#'
#' @description
#' This data set includes the number of yearly measured earthquakes from 1900
#' to 2006.
#'
#' @docType data
#'
#' @usage data(earthquakes)
#'
#' @format
#' A \code{data.frame} with two integer columns, \code{year} for
#' the year and \code{obs} for the number of measured earthquakes.
#'
#' @source
#' The data was obtained from
#' \url{http://hmms-for-time-series.de/second/data/earthquakes.txt}
#' on 2022-03-25.
#'
#' @keywords
#' dataset
"earthquakes"

#' Example application to HMM likelihood
#'
#' @description
#' See the vignette about the HMM likelihood for details:
#' \code{vignette("example_hmm", package = "ino")}
#'
#' @docType data
#'
#' @usage data("hmm_ino")
#'
#' @format
#' A \code{\link{Nop}} object.
#'
#' @keywords
#' dataset
"hmm_ino"

#' Example application of to probit likelihood
#'
#' @description
#' See the vignette about the probit likelihood for details:
#' \code{vignette("example_probit", package = "ino")}
#'
#' @docType data
#'
#' @usage data(probit_ino)
#'
#' @format
#' A \code{\link{Nop}} object.
#'
#' @keywords
#' dataset
"probit_ino"
