% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{warp}
\alias{warp}
\title{Warp image}
\usage{
warp(im, warpfield, mode = 0L, interpolation = 1L, boundary_conditions = 0L)
}
\arguments{
\item{im}{an image}

\item{warpfield}{Warping field. The (x,y,z) fields should be stacked along the colour coordinate.}

\item{mode}{Can be { 0=backward-absolute | 1=backward-relative | 2=forward-absolute | 3=forward-relative }}

\item{interpolation}{Can be <tt>{ 0=nearest | 1=linear | 2=cubic }</tt>.}

\item{boundary_conditions}{Boundary conditions. Can be <tt>{ 0=dirichlet | 1=neumann | 2=periodic }</tt>.}
}
\description{
Warp image
}
\examples{
\dontshow{cimg.limit.openmp()}
#Shift image via warp
warp.x <- imfill(width(boats),height(boats),val=5)
warp.y <- imfill(width(boats),height(boats),val=20)
warpfield <- list(warp.x,warp.y) \%>\% imappend("c")
warp(boats,warpfield,mode=1) \%>\% plot
}
\seealso{
imwarp for a user-friendly interface
}
