% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_correlated_gnp_pair}
\alias{sample_correlated_gnp_pair}
\title{Sample a pair of correlated \eqn{G(n,p)} random graphs}
\usage{
sample_correlated_gnp_pair(n, corr, p, directed = FALSE, permutation = NULL)
}
\arguments{
\item{n}{Numeric scalar, the number of vertices for the sampled graphs.}

\item{corr}{A scalar in the unit interval, the target Pearson correlation
between the adjacency matrices of the original the generated graph (the
adjacency matrix being used as a vector).}

\item{p}{A numeric scalar, the probability of an edge between two vertices,
it must in the open (0,1) interval.}

\item{directed}{Logical scalar, whether to generate directed graphs.}

\item{permutation}{A numeric vector, a permutation vector that is applied on
the vertices of the first graph, to get the second graph.  If \code{NULL},
the vertices are not permuted.}
}
\value{
A list of two igraph objects, named \code{graph1} and
\code{graph2}, which are two graphs whose adjacency matrix entries are
correlated with \code{corr}.
}
\description{
Sample a new graph by perturbing the adjacency matrix of a given graph and
shuffling its vertices.
}
\details{
Please see the reference given below.
}
\examples{
gg <- sample_correlated_gnp_pair(
  n = 10, corr = .8, p = .5,
  directed = FALSE
)
gg
cor(as.vector(gg[[1]][]), as.vector(gg[[2]][]))
}
\references{
Lyzinski, V., Fishkind, D. E., Priebe, C. E. (2013).  Seeded
graph matching for correlated Erdős-Rényi graphs.
\url{https://arxiv.org/abs/1304.7844}
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()}
}
\concept{games}
\keyword{graphs}
