% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_infomap}
\alias{cluster_infomap}
\title{Infomap community finding}
\usage{
cluster_infomap(
  graph,
  e.weights = NULL,
  v.weights = NULL,
  nb.trials = 10,
  modularity = TRUE
)
}
\arguments{
\item{graph}{The input graph. Edge directions will be taken into account.}

\item{e.weights}{If not \code{NULL}, then a numeric vector of edge weights.
The length must match the number of edges in the graph.  By default the
\sQuote{\code{weight}} edge attribute is used as weights. If it is not
present, then all edges are considered to have the same weight.
Larger edge weights correspond to stronger connections.}

\item{v.weights}{If not \code{NULL}, then a numeric vector of vertex
weights. The length must match the number of vertices in the graph.  By
default the \sQuote{\code{weight}} vertex attribute is used as weights. If
it is not present, then all vertices are considered to have the same weight.
A larger vertex weight means a larger probability that the random surfer
jumps to that vertex.}

\item{nb.trials}{The number of attempts to partition the network (can be any
integer value equal or larger than 1).}

\item{modularity}{Logical scalar, whether to calculate the modularity score
of the detected community structure.}
}
\value{
\code{cluster_infomap()} returns a \code{\link[=communities]{communities()}} object,
please see the \code{\link[=communities]{communities()}} manual page for details.
}
\description{
Find community structure that minimizes the expected description length of a
random walker trajectory. If the graph is directed, edge directions will
be taken into account.
}
\details{
Please see the details of this method in the references given below.
}
\examples{

## Zachary's karate club
g <- make_graph("Zachary")

imc <- cluster_infomap(g)
membership(imc)
communities(imc)

}
\references{
The original paper: M. Rosvall and C. T. Bergstrom, Maps of
information flow reveal community structure in complex networks, \emph{PNAS}
105, 1118 (2008) \doi{10.1073/pnas.0706851105}, \url{https://arxiv.org/abs/0707.0609}

A more detailed paper: M. Rosvall, D. Axelsson, and C. T. Bergstrom, The map
equation, \emph{Eur. Phys. J. Special Topics} 178, 13 (2009).
\doi{10.1140/epjst/e2010-01179-1}, \url{https://arxiv.org/abs/0906.1405}.
}
\seealso{
Other community finding methods and \code{\link[=communities]{communities()}}.

Community detection
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\author{
Martin Rosvall wrote the original C++ code. This was ported to
be more igraph-like by Emmanuel Navarro.  The R interface and
some cosmetics was done by Gabor Csardi \email{csardi.gabor@gmail.com}.
}
\concept{community}
\keyword{graphs}
