% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo.R
\name{igraph_demo}
\alias{igraph_demo}
\alias{igraphdemo}
\title{Run igraph demos, step by step}
\usage{
igraph_demo(which)
}
\arguments{
\item{which}{If not given, then the names of the available demos are listed.
Otherwise it should be either a filename or the name of an igraph demo.}
}
\value{
Returns \code{NULL}, invisibly.
}
\description{
Run one of the accompanying igraph demos, somewhat interactively, using a Tk
window.
}
\details{
This function provides a somewhat nicer interface to igraph demos that come
with the package, than the standard \code{\link[=demo]{demo()}} function. igraph
demos are divided into chunks and \code{igraph_demo()} runs them chunk by
chunk, with the possibility of inspecting the workspace between two chunks.

The \code{tcltk} package is needed for \code{igraph_demo()}.
}
\examples{

igraph_demo()
if (interactive()) {
  igraph_demo("centrality")
}

}
\seealso{
\code{\link[=demo]{demo()}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{demo}
\keyword{graphs}
