% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_on_grid}
\alias{layout_on_grid}
\alias{layout.grid}
\alias{layout.grid.3d}
\alias{on_grid}
\title{Simple grid layout}
\usage{
layout_on_grid(graph, width = 0, height = 0, dim = 2)

on_grid(...)

layout.grid.3d(graph, width = 0, height = 0)
}
\arguments{
\item{graph}{The input graph.}

\item{width}{The number of vertices in a single row of the grid. If this is
zero or negative, then for 2d layouts the width of the grid will be the
square root of the number of vertices in the graph, rounded up to the next
integer. Similarly, it will be the cube root for 3d layouts.}

\item{height}{The number of vertices in a single column of the grid, for
three dimensional layouts. If this is zero or negative, then it is
determinted automatically.}

\item{dim}{Two or three. Whether to make 2d or a 3d layout.}

\item{...}{Passed to \code{layout_on_grid()}.}
}
\value{
A two-column or three-column matrix.
}
\description{
This layout places vertices on a rectangular grid, in two or three
dimensions.
}
\details{
The function places the vertices on a simple rectangular grid, one after the
other. If you want to change the order of the vertices, then see the
\code{\link[=permute]{permute()}} function.
}
\examples{

g <- make_lattice(c(3, 3))
layout_on_grid(g)

g2 <- make_lattice(c(3, 3, 3))
layout_on_grid(g2, dim = 3)

plot(g, layout = layout_on_grid)
if (interactive()) {
  rglplot(g, layout = layout_on_grid(g, dim = 3))
}
}
\seealso{
\code{\link[=layout]{layout()}} for other layout generators

Other graph layouts: 
\code{\link{add_layout_}()},
\code{\link{component_wise}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_in_circle}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_sphere}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_fr}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_mds}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{layout_}()},
\code{\link{merge_coords}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
