% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_adjacency_matrix}
\alias{as_adjacency_matrix}
\alias{get.adjacency}
\alias{as_adj}
\title{Convert a graph to an adjacency matrix}
\usage{
as_adjacency_matrix(
  graph,
  type = c("both", "upper", "lower"),
  attr = NULL,
  edges = FALSE,
  names = TRUE,
  sparse = igraph_opt("sparsematrices")
)

as_adj(
  graph,
  type = c("both", "upper", "lower"),
  attr = NULL,
  edges = FALSE,
  names = TRUE,
  sparse = igraph_opt("sparsematrices")
)
}
\arguments{
\item{graph}{The graph to convert.}

\item{type}{Gives how to create the adjacency matrix for undirected graphs.
It is ignored for directed graphs. Possible values: \code{upper}: the upper
right triangle of the matrix is used, \code{lower}: the lower left triangle
of the matrix is used. \code{both}: the whole matrix is used, a symmetric
matrix is returned.}

\item{attr}{Either \code{NULL} or a character string giving an edge
attribute name. If \code{NULL} a traditional adjacency matrix is returned.
If not \code{NULL} then the values of the given edge attribute are included
in the adjacency matrix. If the graph has multiple edges, the edge attribute
of an arbitrarily chosen edge (for the multiple edges) is included. This
argument is ignored if \code{edges} is \code{TRUE}.

Note that this works only for certain attribute types. If the \code{sparse}
argumen is \code{TRUE}, then the attribute must be either logical or
numeric. If the \code{sparse} argument is \code{FALSE}, then character is
also allowed. The reason for the difference is that the \code{Matrix}
package does not support character sparse matrices yet.}

\item{edges}{Logical scalar, whether to return the edge ids in the matrix.
For non-existant edges zero is returned.}

\item{names}{Logical constant, whether to assign row and column names
to the matrix. These are only assigned if the \code{name} vertex attribute
is present in the graph.}

\item{sparse}{Logical scalar, whether to create a sparse matrix. The
\sQuote{\code{Matrix}} package must be installed for creating sparse
matrices.}
}
\value{
A \code{vcount(graph)} by \code{vcount(graph)} (usually) numeric
matrix.
}
\description{
Sometimes it is useful to work with a standard representation of a
graph, like an adjacency matrix.
}
\details{
\code{as_adjacency_matrix()} returns the adjacency matrix of a graph, a
regular matrix if \code{sparse} is \code{FALSE}, or a sparse matrix, as
defined in the \sQuote{\code{Matrix}} package, if \code{sparse} if
\code{TRUE}.
}
\examples{

g <- sample_gnp(10, 2 / 10)
as_adjacency_matrix(g)
V(g)$name <- letters[1:vcount(g)]
as_adjacency_matrix(g)
E(g)$weight <- runif(ecount(g))
as_adjacency_matrix(g, attr = "weight")
}
\seealso{
\code{\link[=graph_from_adjacency_matrix]{graph_from_adjacency_matrix()}}, \code{\link[=read_graph]{read_graph()}}

Other conversion: 
\code{\link{as.directed}()},
\code{\link{as.matrix.igraph}()},
\code{\link{as_adj_list}()},
\code{\link{as_data_frame}()},
\code{\link{as_edgelist}()},
\code{\link{as_graphnel}()},
\code{\link{as_incidence_matrix}()},
\code{\link{as_long_data_frame}()},
\code{\link{graph_from_adj_list}()},
\code{\link{graph_from_graphnel}()}

Other conversion: 
\code{\link{as.directed}()},
\code{\link{as.matrix.igraph}()},
\code{\link{as_adj_list}()},
\code{\link{as_data_frame}()},
\code{\link{as_edgelist}()},
\code{\link{as_graphnel}()},
\code{\link{as_incidence_matrix}()},
\code{\link{as_long_data_frame}()},
\code{\link{graph_from_adj_list}()},
\code{\link{graph_from_graphnel}()}
}
\concept{conversion}
