% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utilities.R
\name{getFitEsts}
\alias{getFitEsts}
\title{Get Survival Curve Estimates from icenReg Model}
\usage{
getFitEsts(fit, newdata = NULL, p, q)
}
\arguments{
\item{fit}{model fit with \code{ic_par} or \code{ic_sp}}

\item{newdata}{\code{data.frame} containing covariates}

\item{p}{Percentiles}

\item{q}{Quantiles}
}
\description{
Gets probability or quantile estimates from a \code{ic_sp}, \code{ic_par} or \code{ic_bayes} object. 
Provided estimates conditional on regression parameters found in \code{newdata}.
}
\details{
For the \code{ic_sp} and \code{ic_par}, the MLE estimate is returned. For \code{ic_bayes}, 
the MAP estimate is returned. To compute the posterior means, use \code{sampleSurv}.

If \code{newdata} is left blank, baseline estimates will be returned (i.e. all covariates = 0). 
If \code{p} is provided, will return the estimated Q(p | x), where Q is the inverse of F. If \code{q} is provided, 
will return the estimated F(q | x). If neither \code{p} nor \code{q} are provided, 
the estimated conditional median is returned.
 
In the case of \code{ic_sp}, the MLE of the baseline survival is not necessarily unique, 
as probability mass is assigned to disjoint Turnbull intervals, but the likelihood function is 
indifferent to how probability mass is assigned within these intervals. In order to have a well 
defined estimate returned, we assume probability is assigned uniformly in these intervals. 
In otherwords, we return *a* maximum likelihood estimate, but don't attempt to characterize *all* maximum 
likelihood estimates with this function. If that is desired, all the information needed can be 
extracted with \code{getSCurves}.
}
\examples{
simdata <- simIC_weib(n = 500, b1 = .3, b2 = -.3,
inspections = 6, inspectLength = 1)
fit <- ic_par(Surv(l, u, type = 'interval2') ~ x1 + x2,
             data = simdata)
new_data <- data.frame(x1 = c(1,2), x2 = c(-1,1))
rownames(new_data) <- c('grp1', 'grp2')

estQ <- getFitEsts(fit, new_data, p = c(.25, .75))

estP <- getFitEsts(fit, q = 400)
}
\author{
Clifford Anderson-Bergman
}
