% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb.zihmle.r, R/bnb.zihmle.r, R/nb.zihmle.r,
%   R/poisson.zihmle.r
\name{bb.zihmle}
\alias{bb.zihmle}
\alias{bnb.zihmle}
\alias{nb.zihmle}
\alias{poisson.zihmle}
\title{Maximum likelihood estimate for zero-inflated or hurdle beta binomial distributions.}
\usage{
bb.zihmle(x, n, alpha1, alpha2, type = c("zi", "h"), lowerbound = 0.01,
  upperbound = 10000)

bnb.zihmle(x, r, alpha1, alpha2, type = c("zi", "h"),
  lowerbound = 0.01, upperbound = 10000)

nb.zihmle(x, r, p, type = c("zi", "h"), lowerbound = 0.01,
  upperbound = 10000)

poisson.zihmle(x, type = c("zi", "h"), lowerbound = 0.01,
  upperbound = 10000)
}
\arguments{
\item{x}{A vector of count data. Should be non-negative integers.}

\item{n}{An initial value of the number of trials. Must be a positive number, but not required to be an integer.}

\item{alpha1}{An initial value for the first shape parameter of beta distribution. Should be a positive number.}

\item{alpha2}{An initial value for the second shape parameter of beta distribution. Should be a positive number.}

\item{type}{The type of distribution used to calculate the sample estimate, where 'zi' and 'h' stand for zero-inflated
and hurdle distributions respectively.}

\item{lowerbound}{A lower searching bound used in the optimization of likelihood function. Should be a small positive number.
The default is 1e-2.}

\item{upperbound}{An upper searching bound used in the optimization of likelihood function. Should be a large positive number.
The default is 1e4.}

\item{r}{An initial value of the number of success before which m failures are observed, where m is the element of x.
Must be a positive number, but not required to be an integer.}

\item{p}{An initial value of the probability of success, should be a positive value within (0,1).}
}
\value{
A row vector containing the maximum likelihood estimate of unknown parameters and the corresponding value of log likelihood.

With \code{bb.zihmle}, the following values are returned:
\itemize{
  \item{n: the maximum likelihood estimate of n.}
  \item{alpha1: the maximum likelihood estimate of alpha1.}
  \item{alpha2: the maximum likelihood estimate of alpha2.}
  \item{phi: the maximum likelihood estimate of \eqn{\phi}.}
  \item{loglik: the value of log likelihood with maximum likelihood estimates plugged-in.}
}
With \code{bnb.zihmle}, the following values are returned:
\itemize{
  \item{r: the maximum likelihood estimate of r.}
  \item{alpha1: the maximum likelihood estimate of alpha1.}
  \item{alpha2: the maximum likelihood estimate of alpha2.}
  \item{phi: the maximum likelihood estimate of \eqn{\phi}.}
  \item{loglik: the value of log likelihood with maximum likelihood estimates plugged-in.}
}
With \code{nb.zihmle}, the following values are returned:
\itemize{
  \item{r: the maximum likelihood estimate of r.}
  \item{p: the maximum likelihood estimate of p.}
  \item{phi: the maximum likelihood estimate of \eqn{\phi}.}
  \item{loglik: the value of log likelihood with maximum likelihood estimates plugged-in.}
}
With \code{poisson.zihmle}, the following values are returned:
\itemize{
  \item{lambda: the maximum likelihood estimate of lambda.}
  \item{phi: the maximum likelihood estimate of \eqn{\phi}.}
  \item{loglik: the value of log likelihood with maximum likelihood estimate plugged-in.}
}
}
\description{
Calculate maximum likelihood estimate and the corresponding log likelihood value for zero-inflated or hurdle
 beta binomial, beta negative binomial, negative binomial and Poisson distributions.
}
\details{
By setting \code{type='zi'}, \code{bb.zihmle}, \code{bnb.zihmle}, \code{nb.zihmle} and \code{poisson.zihmle} calculate the
 maximum likelihood estimate of zero-inflated beta binomial, beta negative binomial, negative binomial and Poisson
 distributions, respectively.

By setting \code{type='h'}, \code{bb.zihmle}, \code{bnb.zihmle}, \code{nb.zihmle} and \code{poisson.zihmle} calculate the
 maximum likelihood estimate of hurdle beta binomial, beta negative binomial, negative binomial and Poisson
 distributions, respectively.

Please NOTE that the arguments in the four functions are NOT CHECKED AT ALL! The user must be aware of their inputs to avoid
getting suspicious results.

For zero-inflated models, zeros occurred by either sampling process or specific structure of data with the structural parameter
\eqn{0<\phi<1}. The density function for a zero-inflated model is

\eqn{P_{zi}(X=k)=\phi 1_{k=0}+(1-\phi)P(X=k)},

where \eqn{P(X=k)} is the probability under standard distributions.

Aldirawi et al. (2019) proposed an estimating procedure for zero-inflated models by optimizing over a reparametrization of
the likelihood function where \eqn{\phi} and the rest unknown parameters are separable. When \eqn{X} comes from a
zero-inflated distribution, the maximum likelihood estimate of parameters except for \eqn{\phi} are obtained by minimizing
the truncated version of negative log likelihood function. However, in the zero-deflated case, \eqn{\phi=0} and the sample
estimate of other parameters are identical to those for its corresponding standard distributions. Meanwhile, an warning
message is shown on the screen such that 'cannot obtain mle with the current model type, the output estimate is derived from
general ... distribution'.

For hurdle models, all zeros occurred purely by the structure of data with the structural parameter \eqn{0<\phi<1}.
The density function for a hurdle model is

\eqn{P_{h}(X=k)=\phi 1_{k=0}+(1-\phi)P_{tr}(X=k)},

where \eqn{P_{tr}(X=k)} is the truncated probability under standard distributions, where \eqn{P_{tr}(X=0)=0} and
\eqn{P_{tr}(X=k)=P(X=k)/(1-P(X=0))}. Since \eqn{\phi} and other unknown parameters are separable in the joint likelihood
 function, \eqn{\phi} can be estimated by a value with respect to the number of positive samples. The sample estimate of
 other parameters can be obtained by the same procedure for zero-inflated model.

A warning message may also occur when the algorithm of \code{optim} does not converge and the resulting estimates are not
 valid. In this case, the results from the corresponding general distribution are output instead.
}
\section{Reference}{

\itemize{
 \item{H. Aldirawi, J. Yang, A. A. Metwally (2019). Identifying Appropriate Probabilistic Models for Sparse Discrete Omics Data,
 accepted for publication in 2019 IEEE EMBS International Conference on Biomedical & Health Informatics (BHI).}
 \item{H. Aldirawi, J. Yang (2019). Model Selection and Regression Analysis for Zero-altered or Zero-inflated Data, Statistical
 Laboratory Technical Report, no.2019-01, University of Illinois at Chicago.}
}
}

\examples{
t1=sample.h(N=2000,phi=0.2,distri='Poisson',lambda=5)  ##hurdle poisson random values
t2=sample.h(N=2000,phi=0.2,distri='nb',r=10,p=0.6)   ##hurdle negative binomial
t3=sample.zi(N=2000,phi=0.2,distri='bb',alpha1=8,alpha2=9,n=10)   ##zero-inflated beta binomial
##zero-inflated beta negative binomial.
t4=sample.zi(N=2000,phi=0.2,distri='bnb',r=10,alpha1=8,alpha2=9)
bb.zihmle(t3,3,1,1,type='h')
bnb.zihmle(t4, 3.3, 1, 1,type='h')
nb.zihmle(t2, 7, 0.5,type='zi')
poisson.zihmle(t1,type='zi')
}
