% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column-to-header.R
\name{column_to_header}
\alias{column_to_header}
\title{Convert a column to header rows}
\usage{
column_to_header(
  ht,
  col,
  ...,
  glue = "{value}",
  start_col = 1,
  ignore_headers = TRUE,
  set_headers = TRUE
)
}
\arguments{
\item{ht}{A huxtable.}

\item{col}{A column specifier for a single column.}

\item{...}{Properties to set on new rows}

\item{glue}{Glue string. \code{"{value}"} will be replaced by the column value.}

\item{start_col}{Integer. New header text will start at this column.}

\item{ignore_headers}{Logical. Ignore existing headers?}

\item{set_headers}{Logical. Set new rows as headers?}
}
\description{
Convert a column to header rows
}
\examples{
column_to_header(jams, "Type")
column_to_header(jams, "Type", text_color = "red")
column_to_header(jams, "Price",
                   number_format = 2,
                   italic = TRUE,
                   glue = "Price: {value}")

iris_hux <- as_hux(iris[c(1:4, 51:54, 101:104), ])
column_to_header(iris_hux, "Species",
                   markdown = TRUE,
                   glue = "Species: **{value}**"
                 )
}
