% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{bold}
\alias{bold}
\alias{bold<-}
\alias{set_bold}
\alias{map_bold}
\alias{italic}
\alias{italic<-}
\alias{set_italic}
\alias{map_italic}
\title{Make cell text bold or italic}
\usage{
bold(ht)
bold(ht) <- value
set_bold(ht, row, col, value = TRUE)
map_bold(ht, row, col, fn)

italic(ht)
italic(ht) <- value
set_italic(ht, row, col, value = TRUE)
map_italic(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{A logical vector or matrix.

Set to \code{NA} to reset to the default, which is \code{FALSE}.}
}
\value{
\code{bold()} returns the \code{bold} property.
\code{set_bold()} returns the modified huxtable.
}
\description{
Make cell text bold or italic
}
\examples{

bold(jams) <-  TRUE
bold(jams)

set_bold(jams, FALSE)
set_bold(jams,
      2:3, 1, FALSE)
map_bold(jams,
      by_rows(FALSE, TRUE))
}
\seealso{
Other formatting functions: 
\code{\link{background_color}()},
\code{\link{font}()},
\code{\link{font_size}()},
\code{\link{na_string}()},
\code{\link{number_format}()},
\code{\link{text_color}()}
}
\concept{formatting functions}
