% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-url.R
\name{req_url}
\alias{req_url}
\alias{req_url_query}
\alias{req_url_path}
\alias{req_url_path_append}
\title{Modify request URL}
\usage{
req_url(req, url)

req_url_query(.req, ..., .multi = c("error", "comma", "pipe", "explode"))

req_url_path(req, ...)

req_url_path_append(req, ...)
}
\arguments{
\item{req, .req}{A httr2 \link{request} object.}

\item{url}{New URL; completely replaces existing.}

\item{...}{For \code{req_url_query()}: <\code{\link[rlang:dyn-dots]{dynamic-dots}}>
Name-value pairs that define query parameters. Each value must be either
an atomic vector or \code{NULL} (which removes the corresponding parameters).
If you want to opt out of escaping, wrap strings in \code{I()}.

For \code{req_url_path()} and \code{req_url_path_append()}: A sequence of path
components that will be combined with \code{/}.}

\item{.multi}{Controls what happens when an element of \code{...} is a vector
containing multiple values:
\itemize{
\item \code{"error"}, the default, throws an error.
\item \code{"comma"}, separates values with a \verb{,}, e.g. \verb{?x=1,2}.
\item \code{"pipe"}, separates values with a \code{|}, e.g. \code{?x=1|2}.
\item \code{"explode"}, turns each element into its own parameter, e.g. \code{?x=1&x=2}.
}

If none of these functions work, you can alternatively supply a function
that takes a character vector and returns a string.}
}
\value{
A modified HTTP \link{request}.
}
\description{
\itemize{
\item \code{req_url()} replaces the entire url
\item \code{req_url_query()} modifies the components of the query
\item \code{req_url_path()} modifies the path
\item \code{req_url_path_append()} adds to the path
}
}
\examples{
req <- request("http://example.com")

# Change url components
req |>
  req_url_path_append("a") |>
  req_url_path_append("b") |>
  req_url_path_append("search.html") |>
  req_url_query(q = "the cool ice")

# Change complete url
req |>
  req_url("http://google.com")

# Use .multi to control what happens with vector parameters:
req |> req_url_query(id = 100:105, .multi = "comma")
req |> req_url_query(id = 100:105, .multi = "explode")

# If you have query parameters in a list, use !!!
params <- list(a = "1", b = "2")
req |>
  req_url_query(!!!params, c = "3")
}
