% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hchart-shorcuts.R
\name{hctreemap2}
\alias{hctreemap2}
\title{Shortcut to create treemaps.}
\usage{
hctreemap2(data, group_vars, size_var, color_var = NULL, ...)
}
\arguments{
\item{data}{data frame containing variables to organize each level of the treemap on}

\item{group_vars}{vector of strings containing column names of variables to generate treemap levels from. the first listed column will specify the top level of the treemap. the unique values in each of these columns must have no intersection (including NAs).}

\item{size_var}{string name of column containing numeric data to aggregate by}

\item{color_var}{string name of column containing numeric data to color by. defaults to same column as \code{size_var}}

\item{...}{additional shared arguments for the data series
(\url{https://api.highcharts.com/highcharts/series}).}
}
\value{
highchart plot object
}
\description{
This function helps create highcharts treemaps from data frames.
}
\examples{
\dontrun{

library(tidyverse)
library(highcharter)
library(RColorBrewer)

tibble(
  index1 = sample(LETTERS[1:5], 500, replace = T),
  index2 = sample(LETTERS[6:10], 500, replace = T),
  index3 = sample(LETTERS[11:15], 500, replace = T),
  value = rpois(500, 5),
  color_value = rpois(500, 5)
) \%>\%
  hctreemap2(
    group_vars = c("index1", "index2", "index3"),
    size_var = "value",
    color_var = "color_value",
    layoutAlgorithm = "squarified",
    levelIsConstant = FALSE,
    levels = list(
      list(level = 1, dataLabels = list(enabled = TRUE)),
      list(level = 2, dataLabels = list(enabled = FALSE)),
      list(level = 3, dataLabels = list(enabled = FALSE))
    )
  ) \%>\%
  hc_colorAxis(
    minColor = brewer.pal(7, "Greens")[1],
    maxColor = brewer.pal(7, "Greens")[7]
  ) \%>\%
  hc_tooltip(pointFormat = "<b>{point.name}</b>:<br>
             Value: {point.value:,.0f}<br>
             Color Value: {point.colorValue:,.0f}")
}

}
