# Generated by 'dev/generate-highcharts-api.R'
# Generated in 2021-02-02 12:43:12
#

#' Annotations options for highcharter objects
#' 
#' A basic type of an annotation. It allows to add custom labels
#' or shapes. The items  can be tied to points, axis coordinates
#' or chart pixel coordinates.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/annotations}. 
#' 
#' @examples
#' 
#' # Ex 1
#' highchart() %>% 
#'   hc_add_series(
#'     data = c(29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4)
#'   ) %>% 
#'   hc_xAxis(
#'     tickInterval = 0.5,
#'     gridLineWidth = 1  
#'   ) %>% 
#'   hc_annotations(
#'     list(
#'       labels = 
#'         list(
#'           list(
#'             point = list(x = 3, y = 129.2, xAxis = 0, yAxis = 0),
#'             text = "x: {x}<br/>y: {y}"
#'             ),
#'           list(
#'             point = list(x = 9, y = 194.1, xAxis = 0, yAxis = 0),
#'             text = "x: {x}<br/>y: {y}"
#'             ),
#'           list(
#'             point = list(x = 5, y = 100, xAxis = 0),
#'             text = "x: {x}<br/>y: {point.plotY} px"
#'             ),
#'           list(
#'             point = list(x = 0, y = 0),
#'             text = "x: {point.plotX} px<br/>y: {point.plotY} px"
#'             )
#'           )
#'       )
#'     )
#'   
#' # Ex 2
#' df <- data.frame(
#'   x = 1:10,
#'   y = 1:10
#' )
#' 
#' highchart() %>% 
#'   hc_add_series(data = df, hcaes(x = x, y = y), type = "area") %>% 
#'   hc_annotations(
#'     list(
#'       labels = list(
#'         list(point = list(x = 5, y = 5, xAxis = 0, yAxis = 0), text = "Middle"),
#'         list(point = list(x = 1, y = 1, xAxis = 0, yAxis = 0), text = "Start")
#'       )
#'     )
#'   )
#' 
#' @export
hc_annotations <- function(hc, ...) {
  
  .hc_opt(hc, "annotations", ...)
  
}

#' Boost options for highcharter objects
#' 
#' Options for the Boost module. The Boost module allows certain series types
#' to be rendered by WebGL instead of the default SVG. This allows hundreds of
#' thousands of data points to be rendered in milliseconds. In addition to the
#' WebGL rendering it saves time by skipping processing and inspection of the
#' data wherever possible. This introduces some limitations to what features are
#' available in boost mode. See the docs for
#' details.
#' In addition to the global boost option, each series has a
#' boostThreshold that defines when the
#' boost should kick in.
#' Requires the modules/boost.js module.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/boost}. 
#' 
#' @examples
#' 
#' #  Ex 1
#' options(highcharter.rjson = FALSE)
#' 
#' n <- 50000
#' 
#' x <- sin(4*2*pi*seq(n)/n) + rnorm(n)/10
#' 
#' x <- round(x, 3)
#' 
#' plot(x)
#' 
#' hc1 <- highchart() %>%
#'   hc_chart(zoomType = "x") %>%
#'   hc_add_series(data = x) %>% 
#'   hc_title(text = "No boost") %>% 
#'   hc_boost(
#'     enabled = FALSE # Default
#'   )
#' 
#' hc1
#' 
#' # Boost is a stripped-down renderer-in-a-module for Highcharts. It bypasses
#' # some of the standard Highcharts features (such as animation), and focuses
#' # on pushing as many points as possible as quickly as possible.
#' 
#' hc2 <- highchart() %>%
#'   hc_chart(zoomType = "x") %>%
#'   hc_add_series(data = x) %>% 
#'   hc_title(text = "With boost") %>% 
#'   hc_boost(enabled = TRUE)
#' 
#' hc2
#' 
#' 
#' # # Ex 2
#' # library(MASS)
#' # 
#' # n <- 20000
#' # 
#' # sigma <- matrix(c(10,3,3,2),2,2)
#' # sigma
#' # 
#' # mvr <- round(mvrnorm(n, rep(c(0, 0)), sigma), 2)
#' # 
#' # vx <- ceiling(1+abs(max(mvr[, 1])))
#' # vy <- ceiling(1+abs(max(mvr[, 2])))
#' # 
#' # # unnamed list
#' # ds <- list_parse2(as.data.frame(mvr))
#' # 
#' # highchart() %>%
#' #   hc_chart(zoomType = "xy") %>%
#' #   hc_xAxis(min = -vx, max = vx) %>% 
#' #   hc_yAxis(min = -vy, max = vy) %>% 
#' #   hc_add_series(
#' #     data = ds, #list
#' #     type = "scatter",
#' #     name = "A lot of points!",
#' #     color = 'rgba(0,0,0,0.1)',
#' #     marker = list(radius = 2)
#' #     ) %>% 
#' #   hc_boost(
#' #     enabled = TRUE 
#' #   )
#' # 
#' # dat <- as.data.frame(mvr)
#' # names(dat) <- c("x", "y")
#' # 
#' # highchart() %>%
#' #   hc_chart(zoomType = "xy") %>%
#' #   hc_xAxis(min = -vx, max = vx) %>% 
#' #   hc_yAxis(min = -vy, max = vy) %>% 
#' #   hc_add_series(
#' #     data = dat,
#' #     type = "scatter",
#' #     hcaes(x, y),
#' #     name = "A lot of points!",
#' #     color = 'rgba(0,0,0,0.1)',
#' #     marker = list(radius = 2)
#' #   ) %>% 
#' #   hc_boost(enabled = TRUE)
#' # 
#' # # Ex3
#' # N <- 1000000
#' # n <- 5
#' # s <- seq(n)
#' # s <- s/(max(s) + min(s))
#' # s <- round(s, 2)
#' # 
#' # series <- s %>%
#' #   purrr::map(~ stats::arima.sim(round(N/n), model = list(ar = .x)) + .x * n * 20) %>%
#' #   purrr::map(as.vector) %>%
#' #   purrr::map(round, 2) %>%
#' #   purrr::map(~ list(data = .x))
#' # 
#' # highchart() %>%
#' #   hc_add_series_list(series) %>%
#' #   hc_chart(zoomType = "x") %>% 
#' #   hc_boost(enabled = TRUE)
#' 
#' @export
hc_boost <- function(hc, ...) {
  
  .hc_opt(hc, "boost", ...)
  
}

#' Caption options for highcharter objects
#' 
#' The chart's caption, which will render below the chart and will be part
#' of exported charts. The caption can be updated after chart initialization
#' through the Chart.update or Chart.caption.update methods.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/caption}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_title(text= "Chart with a caption") %>% 
#'   hc_subtitle(text= "This is the subtitle") %>% 
#'   hc_xAxis(categories = c("Apples", "Pears", "Banana", "Orange")) %>% 
#'   hc_add_series(
#'     data = c(1, 4, 3, 5),
#'     type = "column",
#'     name = "Fruits"
#'   ) %>% 
#'   hc_caption(
#'     text = "<b>The caption renders in the bottom, and is part of the exported
#'     chart.</b><br><em>Lorem ipsum dolor sit amet, consectetur adipiscing elit,
#'     sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim
#'     ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip 
#'     ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate 
#'     velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat 
#'     cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est
#'     laborum.</em>'"
#'   )
#' 
#' @export
hc_caption <- function(hc, ...) {
  
  .hc_opt(hc, "caption", ...)
  
}

#' Chart options for highcharter objects
#' 
#' General options for the chart.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/chart}. 
#' 
#' @examples
#' 
#' hc <- highchart() %>% 
#'   hc_xAxis(categories = month.abb) %>% 
#'   hc_add_series(name = "Tokyo", data = sample(1:12)) %>% 
#'   hc_add_series(name = "London", data = sample(1:12) + 10)
#' 
#' hc
#' 
#' hc %>% 
#'   hc_chart(
#'     type = "column",
#'     options3d = list(enabled = TRUE, beta = 15, alpha = 15)
#'     )
#' 
#' 
#' hc %>% 
#'   hc_chart(
#'     borderColor = "#EBBA95",
#'     borderRadius = 10,
#'     borderWidth = 2,
#'     backgroundColor = list(
#'       linearGradient = c(0, 0, 500, 500),
#'       stops = list(
#'         list(0, 'rgb(255, 255, 255)'),
#'         list(1, 'rgb(200, 200, 255)')
#'              )
#'       )
#'     )
#' 
#' 
#' @export
hc_chart <- function(hc, ...) {
  
  .hc_opt(hc, "chart", ...)
  
}

#' Coloraxis options for highcharter objects
#' 
#' A color axis for series. Visually, the color
#' axis will appear as a gradient or as separate items inside the
#' legend, depending on whether the axis is scalar or based on data
#' classes.
#' For supported color formats, see the
#' docs article about colors.
#' A scalar color axis is represented by a gradient. The colors either
#' range between the minColor and the
#' maxColor, or for more fine grained control the
#' colors can be defined in stops. Often times, the
#' color axis needs to be adjusted to get the right color spread for the
#' data. In addition to stops, consider using a logarithmic
#' axis type, or setting min and
#' max to avoid the colors being determined by
#' outliers.
#' When dataClasses are used, the ranges are
#' subdivided into separate classes like categories based on their
#' values. This can be used for ranges between two values, but also for
#' a true category. However, when your data is categorized, it may be as
#' convenient to add each category to a separate series.
#' Color axis does not work with: sankey, sunburst, dependencywheel,
#' networkgraph, wordcloud, venn, gauge and solidgauge series
#' types.
#' Since v7.2.0 colorAxis can also be an array of options objects.
#' See the Axis object for
#' programmatic access to the axis.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/colorAxis}. 
#' 
#' @examples
#' 
#' library(dplyr)
#' 
#' data(mpg, package = "ggplot2")
#' 
#' mpgman2 <- mpg %>% 
#'   group_by(manufacturer, year) %>% 
#'   dplyr::summarise(
#'     n = dplyr::n(),
#'     displ = mean(displ)
#'     )
#' 
#' mpgman2
#' 
#' hchart(
#'   mpgman2, "column", hcaes(x = manufacturer, y = n, group = year),
#'   colorKey = "displ",
#'   # color = c("#FCA50A", "#FCFFA4"),
#'   name = c("Year 1999", "Year 2008")
#'   ) %>% 
#'   hc_colorAxis(min = 0, max = 5)
#' 
#' 
#' # defaults to yAxis
#' hchart(iris, "point", hcaes(Sepal.Length, Sepal.Width)) %>% 
#'   hc_colorAxis(
#'     minColor = "red",
#'     maxColor = "blue"
#'   )
#' 
#' 
#' 
#' # Ex2
#' n <- 5
#' 
#' stops <- data.frame(
#'   q = 0:n/n,
#'   c = c("#440154", "#414487", "#2A788E", "#22A884", "#7AD151", "#FDE725"),
#'   stringsAsFactors = FALSE
#'   )
#' 
#' stops <- list_parse2(stops)
#' 
#' M <- round(matrix(rnorm(50*50), ncol = 50), 2)
#' 
#' hchart(M) %>% 
#'   hc_colorAxis(stops = stops)
#' 
#' # Ex3
#' # hchart(volcano) %>% 
#' #   hc_colorAxis(stops = stops, max = 200)
#' 
#' @export
hc_colorAxis <- function(hc, ...) {
  
  .hc_opt(hc, "colorAxis", ...)
  
}

#' Colors options for highcharter objects
#' 
#' An array containing the default colors for the chart's series. When all 
#' colors are used, new colors are pulled from the start again.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param colors A vector of colors. 
#' 
#' @examples
#' 
#' library(viridisLite)
#' 
#' cols <- viridis(3)
#' cols <- substr(cols, 0, 7)
#' 
#' highchart() %>% 
#'   hc_add_series(data = sample(1:12)) %>% 
#'   hc_add_series(data = sample(1:12) + 10) %>% 
#'   hc_add_series(data = sample(1:12) + 20) %>% 
#'   hc_colors(cols)
#' 
#' @export
hc_colors <- function(hc, colors) {
  
  assertthat::assert_that(is.vector(colors))
  
  if (length(colors) == 1)
    colors <- list(colors)

  hc$x$hc_opts$colors <- colors
  
  hc
  
}


#' Credits options for highcharter objects
#' 
#' Highchart by default puts a credits label in the lower right corner
#' of the chart. This can be changed using these options.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/credits}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_xAxis(categories = citytemp$month) %>% 
#'   hc_add_series(name = "Tokyo", data = sample(1:12)) %>% 
#'   hc_credits(
#'     enabled = TRUE,
#'     text = "htmlwidgets.org",
#'     href = "http://www.htmlwidgets.org/"
#'     )
#' 
#' @export
hc_credits <- function(hc, ...) {
  
  .hc_opt(hc, "credits", ...)
  
}

#' Drilldown options for highcharter objects
#' 
#' Options for drill down, the concept of inspecting increasingly high
#' resolution data through clicking on chart items like columns or pie slices.
#' The drilldown feature requires the drilldown.js file to be loaded,
#' found in the modules directory of the download package, or online at
#' code.highcharts.com/modules/drilldown.js.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/drilldown}. 
#' 
#' @examples
#' 
#' library(highcharter)
#' library(dplyr)
#' library(purrr)
#' 
#' df <- tibble(
#'   name = c("Animals", "Fruits"),
#'   y = c(5, 2),
#'   drilldown = tolower(name)
#' )
#' 
#' df
#' 
#' hc <- highchart() %>%
#'   hc_title(text = "Basic drilldown") %>%
#'   hc_xAxis(type = "category") %>%
#'   hc_legend(enabled = FALSE) %>%
#'   hc_plotOptions(
#'     series = list(
#'       boderWidth = 0,
#'       dataLabels = list(enabled = TRUE)
#'     )
#'   ) %>%
#'   hc_add_series(
#'     data = df,
#'     type = "column",
#'     hcaes(name = name, y = y),
#'     name = "Things",
#'     colorByPoint = TRUE
#'   )
#' 
#' dfan <- data.frame(
#'   name = c("Cats", "Dogs", "Cows", "Sheep", "Pigs"),
#'   value = c(4, 3, 1, 2, 1)
#' )
#' 
#' dffru <- data.frame(
#'   name = c("Apple", "Organes"),
#'   value = c(4, 2)
#' )
#' 
#' 
#' dsan <- list_parse2(dfan)
#' 
#' dsfru <- list_parse2(dffru)
#' 
#' hc <- hc %>%
#'   hc_drilldown(
#'     allowPointDrilldown = TRUE,
#'     series = list(
#'       list(
#'         id = "animals",
#'         data = dsan
#'       ),
#'       list(
#'         id = "fruits",
#'         data = dsfru
#'       )
#'     )
#'   )
#' 
#' hc
#' 
#' 
#' 
#' @export
hc_drilldown <- function(hc, ...) {
  
  .hc_opt(hc, "drilldown", ...)
  
}

#' Exporting options for highcharter objects
#' 
#' Options for the exporting module. For an overview on the matter, see
#' the docs.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/exporting}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_xAxis(categories = month.abb) %>% 
#'   hc_add_series(name = "Tokyo", data = sample(1:12)) %>% 
#'   hc_exporting(
#'     enabled = TRUE, # always enabled
#'     filename = "custom-file-name"
#'     )
#' 
#' @export
hc_exporting <- function(hc, ...) {
  
  .hc_opt(hc, "exporting", ...)
  
}

#' Labels options for highcharter objects
#' 
#' HTML labels that can be positioned anywhere in the chart area.
#' This option is deprecated since v7.1.2. Instead, use
#' annotations that support labels.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/labels}. 
#' 
#' @examples
#' 
#' highchart() %>%
#'   hc_add_series(data = sample(1:12)) %>% 
#'   hc_labels(
#'     items = list(
#'       list(
#'         html = "<p>Some <b>important</b><br>text</p>" ,
#'         style = list(
#'           left = "150%",
#'           top = "150%"
#'         )
#'       )
#'     )
#'   )
#' 
#' 
#' @export
hc_labels <- function(hc, ...) {
  
  .hc_opt(hc, "labels", ...)
  
}

#' Legend options for highcharter objects
#' 
#' The legend is a box containing a symbol and name for each series
#' item or point item in the chart. Each series (or points in case
#' of pie charts) is represented by a symbol and its name in the legend.
#' It is possible to override the symbol creator function and create
#' custom legend symbols.
#' 
#' A Highmaps legend by default contains one legend item per series, but if
#' a colorAxis is defined, the axis will be displayed in the legend.
#' Either as a gradient, or as multiple legend items for dataClasses.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/legend}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_xAxis(categories = month.abb) %>% 
#'   hc_add_series(name = "Tokyo", data = sample(1:12)) %>% 
#'   hc_add_series(name = "London", data = sample(1:12) + 10) %>%
#'   hc_add_series(name = "Other City", data = sample(1:12) + 20) %>%
#'   hc_legend(
#'     align = "left",
#'     verticalAlign = "top",
#'     layout = "vertical",
#'     x = 0,
#'     y = 100
#'     ) 
#' 
#' @export
hc_legend <- function(hc, ...) {
  
  .hc_opt(hc, "legend", ...)
  
}

#' Loading options for highcharter objects
#' 
#' The loading options control the appearance of the loading screen
#' that covers the plot area on chart operations. This screen only
#' appears after an explicit call to chart.showLoading(). It is a
#' utility for developers to communicate to the end user that something
#' is going on, for example while retrieving new data via an XHR connection.
#' The "Loading..." text itself is not part of this configuration
#' object, but part of the lang object.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/loading}. 
#' 
#' @examples
#' 
#' highcharts_demo() %>% 
#'   hc_loading(
#'     hideDuration = 1000,
#'     showDuration = 1000
#'   )
#' 
#' @export
hc_loading <- function(hc, ...) {
  
  .hc_opt(hc, "loading", ...)
  
}

#' Pane options for highcharter objects
#' 
#' The pane serves as a container for axes and backgrounds for circular
#' gauges and polar charts.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/pane}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_chart(
#'   type = "gauge",
#'   plotBackgroundColor = NULL,
#'   plotBackgroundImage = NULL,
#'   plotBorderWidth = 0,
#'   plotShadow = FALSE
#'   ) %>% 
#'   hc_title(
#'     text = "Speedometer"
#'   ) %>% 
#'   hc_pane(
#'     startAngle = -150,
#'     endAngle = 150,
#'     background = list(list(
#'       backgroundColor = list(
#'         linearGradient = list( x1 = 0, y1 = 0, x2 = 0, y2 = 1),
#'         stops = list(
#'           list(0, "#FFF"),
#'           list(1, "#333")
#'         )
#'       ),
#'       borderWidth = 0,
#'       outerRadius = "109%"
#'     ), list(
#'       backgroundColor = list(
#'         linearGradient = list( x1 = 0, y1 = 0, x2 = 0, y2 = 1),
#'         stops = list(
#'           list(0, "#333"),
#'           list(1, "#FFF")
#'         )
#'       ),
#'       borderWidth = 1,
#'       outerRadius = "107%"
#'     ), list(
#'       # default background
#'     ), list(
#'       backgroundColor = "#DDD",
#'       borderWidth = 0,
#'       outerRadius = "105%",
#'       innerRadius = "103%"
#'     ))
#'   ) %>% 
#'   hc_add_series(
#'     data = list(80), name = "speed", tooltip = list(valueSuffix = " km/h")
#'   ) %>% 
#'   
#'   
#'   hc_yAxis(
#'     min = 0,
#'     max = 200,
#'     
#'     minorTickInterval = "auto",
#'     minorTickWidth = 1,
#'     minorTickLength = 10,
#'     minorTickPosition = "inside",
#'     minorTickColor = "#666",
#'     
#'     tickPixelInterval = 30,
#'     tickWidth = 2,
#'     tickPosition = "inside",
#'     tickLength = 10,
#'     tickColor = "#666",
#'     
#'     labels = list(
#'       step = 2,
#'       rotation = "auto"
#'     ),
#'     title = list(
#'       text = "km/h"
#'     ),
#'     
#'     plotBands = list(
#'       list(from =   0, to = 120, color = "#55BF3B"),
#'       list(from = 120, to = 160, color = "#DDDF0D"),
#'       list(from = 160, to = 200, color = "#DF5353")
#'     )
#'     
#'   )
#' 
#' 
#' @export
hc_pane <- function(hc, ...) {
  
  .hc_opt(hc, "pane", ...)
  
}

#' Plotoptions options for highcharter objects
#' 
#' The plotOptions is a wrapper object for config objects for each series
#' type. The config objects for each series can also be overridden for
#' each series item as given in the series array.
#' Configuration options for the series are given in three levels. Options
#' for all series in a chart are given in the plotOptions.series object. Then options for all series of a specific
#' type are given in the plotOptions of that type, for example
#' plotOptions.line. Next, options for one single series are given in
#' the series array.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/plotOptions}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_add_series(
#'     data = c(29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4)
#'   ) %>% 
#'   hc_plotOptions(
#'     line = list(
#'       color = "blue",
#'       marker = list(
#'         fillColor = "white",
#'         lineWidth = 2,
#'         lineColor = NULL
#'         )
#'       )
#'     )
#' 
#' @export
hc_plotOptions <- function(hc, ...) {
  
  .hc_opt(hc, "plotOptions", ...)
  
}

#' Responsive options for highcharter objects
#' 
#' Allows setting a set of rules to apply for different screen or chart
#' sizes. Each rule specifies additional chart options.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/responsive}. 
#' 
#' @examples
#' 
#' leg_500_opts <- list(enabled = FALSE)
#' leg_900_opts <- list(align = "right", verticalAlign = "middle",  layout = "vertical")
#' 
#' 
#' # change the with of the container/windows to see the effect
#' highchart() %>% 
#'   hc_add_series(data = cumsum(rnorm(100))) %>% 
#'   hc_responsive(
#'     rules = list(
#'       # remove legend if there is no much space
#'       list(
#'         condition = list(maxWidth  = 500),
#'         chartOptions = list(legend = leg_500_opts)
#'       ),
#'       # put legend on the right when there is much space
#'       list(
#'         condition = list(minWidth  = 900),
#'         chartOptions = list(legend = leg_900_opts)
#'       )
#'     )
#'   )
#' 
#' @export
hc_responsive <- function(hc, ...) {
  
  .hc_opt(hc, "responsive", ...)
  
}

#' Series options for highcharter objects
#' 
#' Series options for specific data and the data itself. In TypeScript you
#' have to cast the series options to specific series types, to get all
#' possible options for a series.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/series}. 
#' 
#' @examples
#' 
#' highchart() %>%  
#'   hc_series(
#'     list(
#'       name = "Tokyo",
#'       data = c(7.0, 6.9, 9.5, 14.5, 18.4, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6)
#'     ),
#'     list(
#'       name = "London",
#'       data = c(3.9, 4.2, 5.7, 8.5, 11.9, 15.2, 17.0, 16.6, 14.2, 10.3, 6.6, 4.8)
#'     )
#'   )
#' 
#' @export
hc_series <- function(hc, ...) {
  
  .hc_opt(hc, "series", ...)
  
}

#' Subtitle options for highcharter objects
#' 
#' The chart's subtitle. This can be used both to display a subtitle below
#' the main title, and to display random text anywhere in the chart. The
#' subtitle can be updated after chart initialization through the
#' Chart.setTitle method.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/subtitle}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_add_series(
#'     data = c(7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6),
#'     type = "column"
#'   ) %>% 
#'   hc_subtitle(
#'     text = "And this is a subtitle with more information",
#'     align = "left",
#'     style = list(color = "#2b908f", fontWeight = "bold")
#'   ) 
#' 
#' @export
hc_subtitle <- function(hc, ...) {
  
  .hc_opt(hc, "subtitle", ...)
  
}

#' Title options for highcharter objects
#' 
#' The chart's main title.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/title}. 
#' 
#' @examples
#' 
#' highchart() %>% 
#'   hc_add_series(
#'     data = c(7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6),
#'     type = "column"
#'     ) %>% 
#'   hc_title(
#'     text = "This is a title with <i>margin</i> and <b>Strong or bold text</b>",
#'     margin = 20,
#'     align = "left",
#'     style = list(color = "#22A884", useHTML = TRUE)
#'     )
#' 
#' @export
hc_title <- function(hc, ...) {
  
  .hc_opt(hc, "title", ...)
  
}

#' Tooltip options for highcharter objects
#' 
#' Options for the tooltip that appears when the user hovers over a
#' series or point.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/tooltip}. 
#' @param sort Logical value to implement sort according `this.point`
#'   \url{http://stackoverflow.com/a/16954666/829971}.
#' @param table Logical value to implement table in tooltip: 
#'   \url{http://stackoverflow.com/a/22327749/829971}.
#' 
#' @examples
#' 
#' highchart() %>%
#'   hc_add_series(data = sample(1:12)) %>% 
#'   hc_add_series(data = sample(1:12) + 10) %>% 
#'   hc_tooltip(
#'     crosshairs = TRUE,
#'     borderWidth = 5,
#'     sort = TRUE,
#'     table = TRUE
#'     ) 
#' 
#' 
#' @export
hc_tooltip <- function(hc, ..., sort = FALSE, table = FALSE) {
  
  if (sort)
    hc <- .hc_tooltip_sort(hc)
  
  if (table)
    hc <- .hc_tooltip_table(hc)
  
  if (length(list(...))) 
    hc <- .hc_opt(hc, "tooltip", ...)
  
  hc  
  
}


#' Xaxis options for highcharter objects
#' 
#' The X axis or category axis. Normally this is the horizontal axis,
#' though if the chart is inverted this is the vertical axis. In case of
#' multiple axes, the xAxis node is an array of configuration objects.
#' See the Axis class for programmatic
#' access to the axis.
#' 
#' In Highmaps, the axis is hidden, but it is used behind the scenes to
#' control features like zooming and panning. Zooming is in effect the same
#' as setting the extremes of one of the exes.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/xAxis}. 
#' 
#' @examples
#' 
#' highchart() %>%
#'   hc_add_series(
#'     data = c(7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6),
#'     type = "spline"
#'     ) %>% 
#'   hc_xAxis(
#'     title = list(text = "x Axis at top"),
#'     alternateGridColor = "#FDFFD5",
#'     opposite = TRUE,
#'     plotLines = list(
#'       list(
#'         label = list(text = "This is a plotLine"),
#'         color = "#FF0000",
#'         width = 2,
#'         value = 5.5
#'         )
#'       )
#'     )
#' 
#' @export
hc_xAxis <- function(hc, ...) {
  
  .hc_opt(hc, "xAxis", ...)
  
}

#' Yaxis options for highcharter objects
#' 
#' The Y axis or value axis. Normally this is the vertical axis,
#' though if the chart is inverted this is the horizontal axis.
#' In case of multiple axes, the yAxis node is an array of
#' configuration objects.
#' See the Axis object for programmatic
#' access to the axis.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/yAxis}. 
#' 
#' @examples
#' 
#' highchart() %>%
#'   hc_add_series(
#'     data = c(7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6),
#'     type = "spline"
#'   ) %>% 
#'   hc_yAxis(
#'     title = list(text = "y Axis at right"),
#'     opposite = TRUE,
#'     alternateGridColor = "#FAFAFA",
#'     minorTickInterval = "auto",
#'     minorGridLineDashStyle = "LongDashDotDot",
#'     showFirstLabel = FALSE,
#'     showLastLabel = FALSE,
#'     plotBands = list(
#'       list(
#'         from = 13,
#'         to = 17,
#'         color = "rgba(100, 0, 0, 0.1)",
#'         label = list(text = "This is a plotBand")
#'         )
#'       )
#'     ) 
#' 
#' @export
hc_yAxis <- function(hc, ...) {
  
  .hc_opt(hc, "yAxis", ...)
  
}

#' Zaxis options for highcharter objects
#' 
#' The Z axis or depth axis for 3D plots.
#' See the Axis class for programmatic
#' access to the axis.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highcharts/zAxis}. 
#' 
#' @examples
#' 
#' df <- data.frame(
#'   x = sample(1:5),
#'   y = sample(1:5),
#'   z = sample(1:5)
#' )
#' 
#' # Note the 3d requiere highchart2() due have the 3d module
#' highchart2() %>%
#'   hc_add_series(data = df, "scatter3d", hcaes(x = x, y = y, z = z)) %>% 
#'   hc_chart(
#'     type = "scatter3d",
#'     options3d = list(
#'       enabled = TRUE,
#'       alpha = 20,
#'       beta = 30,
#'       depth = 200,
#'       viewDistance = 5,
#'       frame = list(
#'         bottom = list(
#'           size = 1,
#'           color = "rgba(0,0,0,0.05)"
#'         )
#'       )
#'     )
#'   ) %>% 
#'   hc_zAxis(
#'     title = list(text = "Z axis is here"),
#'     startOnTick = FALSE,
#'     tickInterval = 2,
#'     tickLength = 4,
#'     tickWidth = 1,
#'     gridLineColor = "red",
#'     gridLineDashStyle = "dot"
#'   )
#' 
#' @export
hc_zAxis <- function(hc, ...) {
  
  .hc_opt(hc, "zAxis", ...)
  
}

#' Navigator options for highcharter objects
#' 
#' The navigator is a small series below the main series, displaying
#' a view of the entire data set. It provides tools to zoom in and
#' out on parts of the data as well as panning across the dataset.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highstock/navigator}. 
#' 
#' @examples
#' 
#' highchart(type = "stock") %>% 
#'   hc_add_series(AirPassengers) %>% 
#'   hc_rangeSelector(selected = 4) %>% 
#'   hc_navigator(
#'     outlineColor = "gray",
#'     outlineWidth = 2,
#'     series = list(
#'       color = "red",
#'       lineWidth = 2,
#'       type = "areaspline", # you can change the type
#'       fillColor = "rgba(255, 0, 0, 0.2)"
#'     ),
#'     handles = list(
#'       backgroundColor = "yellow",
#'       borderColor = "red"
#'     )
#'   )
#' 
#' @export
hc_navigator <- function(hc, ...) {
  
  .hc_opt(hc, "navigator", ...)
  
}

#' Rangeselector options for highcharter objects
#' 
#' The range selector is a tool for selecting ranges to display within
#' the chart. It provides buttons to select preconfigured ranges in
#' the chart, like 1 day, 1 week, 1 month etc. It also provides input
#' boxes where min and max dates can be manually input.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highstock/rangeSelector}. 
#' 
#' @examples
#' 
#' hc <- highchart(type = "stock") %>% 
#'   hc_add_series(AirPassengers)
#' 
#' hc
#' 
#' hc %>% 
#'   hc_rangeSelector(enabled = FALSE)
#' 
#' hc %>% 
#'   hc_rangeSelector(
#'     verticalAlign = "bottom",
#'     selected = 4
#'     )
#' 
#' @export
hc_rangeSelector <- function(hc, ...) {
  
  .hc_opt(hc, "rangeSelector", ...)
  
}

#' Scrollbar options for highcharter objects
#' 
#' The scrollbar is a means of panning over the X axis of a stock chart.
#' Scrollbars can  also be applied to other types of axes.
#' Another approach to scrollable charts is the chart.scrollablePlotArea option that
#' is especially suitable for simpler cartesian charts on mobile.
#' In styled mode, all the presentational options for the
#' scrollbar are replaced by the classes .highcharts-scrollbar-thumb,
#' .highcharts-scrollbar-arrow, .highcharts-scrollbar-button,
#' .highcharts-scrollbar-rifles and .highcharts-scrollbar-track.
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highstock/scrollbar}. 
#' 
#' @examples
#' 
#' highchart(type = "stock") %>% 
#'   hc_add_series(AirPassengers) %>% 
#'   hc_rangeSelector(selected = 4) %>% 
#'   hc_scrollbar(
#'     barBackgroundColor = "gray",
#'     barBorderRadius = 7,
#'     barBorderWidth = 0,
#'     buttonBackgroundColor = "gray",
#'     buttonBorderWidth = 0,
#'     buttonArrowColor = "yellow",
#'     buttonBorderRadius = 7,
#'     rifleColor = "yellow",
#'     trackBackgroundColor = "white",
#'     trackBorderWidth = 1,
#'     trackBorderColor = "silver",
#'     trackBorderRadius = 7
#'   )
#' 
#' @export
hc_scrollbar <- function(hc, ...) {
  
  .hc_opt(hc, "scrollbar", ...)
  
}

#' Mapnavigation options for highcharter objects
#' 
#' @param hc A `highchart` `htmlwidget` object. 
#' @param ... Arguments defined in \url{https://api.highcharts.com/highmaps/mapNavigation}. 
#' 
#' @examples
#' 
#' hcmap(download_map_data = FALSE) %>% 
#'   hc_mapNavigation(
#'     enabled = TRUE,
#'     enableMouseWheelZoom = TRUE,
#'     enableDoubleClickZoom = TRUE
#'   )
#' 
#' @export
hc_mapNavigation <- function(hc, ...) {
  
  .hc_opt(hc, "mapNavigation", ...)
  
}

