test_that("hfr", {
  data("Boston", package = "MASS")
  x <- model.matrix(medv ~ 0 + . + crim*tax, Boston)
  y <- Boston$medv
  expect_no_error(mod_1 <- hfr(x, y, kappa = 1))
  expect_no_error(mod_2 <- hfr(x, y, kappa = 0))
  expect_no_error(mod_3 <- hfr(x, y, kappa = 0.5))

  expect_no_error(coef(mod_1))
  expect_no_error(coef(mod_2))
  expect_no_error(coef(mod_3))
  expect_no_error(predict(mod_1, x))
  expect_no_error(predict(mod_2, x))
  expect_no_error(predict(mod_3, x))
  expect_no_error(fitted(mod_1))
  expect_no_error(fitted(mod_2))
  expect_no_error(fitted(mod_3))
  expect_no_error(se.avg(mod_1))
  expect_no_error(se.avg(mod_2))
  expect_no_error(se.avg(mod_3))
  expect_no_error(plot(mod_1))
  expect_no_error(plot(mod_3))

  expect_false(any(is.na(coef(mod_1))))
  expect_false(any(is.na(coef(mod_2))))
  expect_false(any(is.na(coef(mod_3))))
  expect_false(any(is.na(predict(mod_1, x))))
  expect_false(any(is.na(predict(mod_2, x))))
  expect_false(any(is.na(predict(mod_3, x))))
  expect_false(any(is.na(fitted(mod_1))))
  expect_false(any(is.na(fitted(mod_2))))
  expect_false(any(is.na(fitted(mod_3))))
  expect_false(any(is.na(se.avg(mod_1))))
  expect_false(any(is.na(se.avg(mod_2))))
  expect_false(any(is.na(se.avg(mod_3))))
})

test_that("hfr-linear-dep", {
  data("Boston", package = "MASS")
  x <- model.matrix(medv ~ 0 + . + crim*tax, Boston)
  y <- Boston$medv
  x[,1] <- x[,2]
  expect_warning(mod_1 <- hfr(x, y, kappa = 1))
  expect_warning(mod_2 <- hfr(x, y, kappa = 0))
  expect_warning(mod_3 <- hfr(x, y, kappa = 0.5))

  expect_no_error(coef(mod_1))
  expect_no_error(coef(mod_2))
  expect_no_error(coef(mod_3))
  expect_no_error(predict(mod_1, x))
  expect_no_error(predict(mod_2, x))
  expect_no_error(predict(mod_3, x))
  expect_no_error(fitted(mod_1))
  expect_no_error(fitted(mod_2))
  expect_no_error(fitted(mod_3))
  expect_no_error(se.avg(mod_1))
  expect_no_error(se.avg(mod_2))
  expect_no_error(se.avg(mod_3))
  expect_no_error(plot(mod_1))
  expect_no_error(plot(mod_3))

  expect_false(any(is.na(coef(mod_1))))
  expect_false(any(is.na(coef(mod_2))))
  expect_false(any(is.na(coef(mod_3))))
  expect_false(any(is.na(predict(mod_1, x))))
  expect_false(any(is.na(predict(mod_2, x))))
  expect_false(any(is.na(predict(mod_3, x))))
  expect_false(any(is.na(fitted(mod_1))))
  expect_false(any(is.na(fitted(mod_2))))
  expect_false(any(is.na(fitted(mod_3))))
  expect_false(any(is.na(se.avg(mod_1))))
  expect_false(any(is.na(se.avg(mod_2))))
  expect_false(any(is.na(se.avg(mod_3))))
})

test_that("hfr-const-col", {
  data("Boston", package = "MASS")
  x <- model.matrix(medv ~ 0 + . + crim*tax, Boston)
  y <- Boston$medv
  x[,1] <- 1
  expect_no_error(mod_1 <- hfr(x, y, kappa = 1))
  expect_no_error(mod_2 <- hfr(x, y, kappa = 0))
  expect_no_error(mod_3 <- hfr(x, y, kappa = 0.5))

  expect_no_error(coef(mod_1))
  expect_no_error(coef(mod_2))
  expect_no_error(coef(mod_3))
  expect_no_error(predict(mod_1, x))
  expect_no_error(predict(mod_2, x))
  expect_no_error(predict(mod_3, x))
  expect_no_error(fitted(mod_1))
  expect_no_error(fitted(mod_2))
  expect_no_error(fitted(mod_3))
  expect_no_error(se.avg(mod_1))
  expect_no_error(se.avg(mod_2))
  expect_no_error(se.avg(mod_3))
  expect_warning(plot(mod_1))
  expect_warning(plot(mod_3))

  expect_true(any(is.na(coef(mod_1))))
  expect_true(any(is.na(coef(mod_2))))
  expect_true(any(is.na(coef(mod_3))))
  expect_false(any(is.na(predict(mod_1, x))))
  expect_false(any(is.na(predict(mod_2, x))))
  expect_false(any(is.na(predict(mod_3, x))))
  expect_false(any(is.na(fitted(mod_1))))
  expect_false(any(is.na(fitted(mod_2))))
  expect_false(any(is.na(fitted(mod_3))))
  expect_true(any(is.na(se.avg(mod_1))))
  expect_true(any(is.na(se.avg(mod_2))))
  expect_true(any(is.na(se.avg(mod_3))))
})

test_that("hfr-high-dim", {
  x <- matrix(rnorm(10*15), 10)
  y <- rnorm(10)
  expect_warning(mod_1 <- hfr(x, y, kappa = 1))
  expect_warning(mod_2 <- hfr(x, y, kappa = 0))
  expect_warning(mod_3 <- hfr(x, y, kappa = 0.5))

  expect_no_error(coef(mod_1))
  expect_no_error(coef(mod_2))
  expect_no_error(coef(mod_3))
  expect_no_error(predict(mod_1, x))
  expect_no_error(predict(mod_2, x))
  expect_no_error(predict(mod_3, x))
  expect_no_error(fitted(mod_1))
  expect_no_error(fitted(mod_2))
  expect_no_error(fitted(mod_3))
  expect_no_error(se.avg(mod_1))
  expect_no_error(se.avg(mod_2))
  expect_no_error(se.avg(mod_3))
  expect_no_error(plot(mod_1))
  expect_no_error(plot(mod_3))

  expect_false(any(is.na(coef(mod_1))))
  expect_false(any(is.na(coef(mod_2))))
  expect_false(any(is.na(coef(mod_3))))
  expect_false(any(is.na(predict(mod_1, x))))
  expect_false(any(is.na(predict(mod_2, x))))
  expect_false(any(is.na(predict(mod_3, x))))
  expect_false(any(is.na(fitted(mod_1))))
  expect_false(any(is.na(fitted(mod_2))))
  expect_false(any(is.na(fitted(mod_3))))
  expect_true(any(is.na(se.avg(mod_1))))
  expect_true(any(is.na(se.avg(mod_2))))
  expect_true(any(is.na(se.avg(mod_3))))
})
