% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\docType{data}
\name{setHdd_extract.cap}
\alias{setHdd_extract.cap}
\alias{getHdd_extract.cap}
\title{Sets/gets the size cap when extracting hdd data}
\format{
An object of class \code{function} of length 1.
}
\usage{
setHdd_extract.cap(sizeMB = 3000)

getHdd_extract.cap
}
\arguments{
\item{sizeMB}{Size cap in MB. Default is 3000.}
}
\value{
The size cap, a numeric scalar.
}
\description{
Sets/gets the default size cap when extracting HDD variables with \code{\link[hdd]{cash-.hdd}} or when importing full HDD data sets with \code{\link[hdd]{readfst}}.
}
\details{
In \code{\link[hdd]{readfst}}, if the expected size of the data set exceeds the cap then,
in interactive mode, a confirmation is asked. When not in interactive mode, no confirmation is asked.
This can also be bypassed by using the argument \code{confirm}.
}
\examples{

# Toy example with iris data
# We first create a hdd dataset with approx. 100KB
hdd_path = tempfile() # => folder where the data will be saved
write_hdd(iris, hdd_path)
for(i in 1:10) write_hdd(iris, hdd_path, add = TRUE)

base_hdd = hdd(hdd_path)
summary(base_hdd) # => 11 files

# we can extract the data from the 11 files with '$':
pl = base_hdd$Sepal.Length

#
# Illustration of the protection mechanism:
#

# By default when extracting a variable with '$'
# and the size exceeds the cap (default is greater than 3GB)
# a confirmation is needed.
# You can set the cap with setHdd_extract.cap.

# Following code asks a confirmation:
setHdd_extract.cap(sizeMB = 0.005) # new cap of 5KB
try(pl <- base_hdd$Sepal.Length)

# To extract the variable without changing the cap:
pl = base_hdd[, Sepal.Length] # => no size control is performed

# Resetting the default cap
setHdd_extract.cap()


}
\keyword{datasets}
