% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbam_cv.R
\name{hbam_cv}
\alias{hbam_cv}
\title{Perform K-fold cross-validation for an HBAM-type model}
\usage{
hbam_cv(
  self = NULL,
  stimuli = NULL,
  model = "HBAM",
  allow_miss = 0,
  req_valid = NA,
  req_unique = 2,
  prefs = NULL,
  prep_data = TRUE,
  data = NULL,
  K = 10,
  chains = 2,
  cores = parallel::detectCores(logical = FALSE),
  warmup = 1000,
  iter = 4000,
  thin = 1,
  control = list(adapt_delta = 0.6),
  seed = 1
)
}
\arguments{
\item{self}{A numerical vector of N ideological self-placements. Any missing data must be coded as NA. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{stimuli}{An N × J matrix of numerical stimulus placements, where J is the number of stimuli. Any missing data must be coded as NA. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{model}{Character: Name of the model to be used. Defaults to \code{"HBAM"}.}

\item{allow_miss}{Integer specifying how many missing stimulus positions to be accepted for an individual still to be included in the analysis. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function. Defaults to 0.}

\item{req_valid}{Integer specifying how many valid observations to require for a respondent to be included in the analysis. The default is \code{req_valid = J - allow_miss}, but if specified, \code{req_valid} takes precedence. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{req_unique}{Integer specifying how may unique positions on the ideological scale each respondent is required to have used when placing the stimuli in order to be included in the analysis. The default is \code{req_unique = 2}. This argument will not be used if the data have been prepared in advance via the \code{prep_data} function.}

\item{prefs}{An N × J matrix of numerical stimulus ratings or preference scores. These data are only required by the \code{"HBAM_R"} and \code{"HBAM_R_MINI"} models and will be ignored when fitting other models.}

\item{prep_data}{Logical: Should the data be prepared before fitting the model? (Or have the data been prepared in advance by first running the \code{prep_data} and \code{prep_data_cv} functions)? If so, set \code{prep_data = FALSE}.) Defaults to \code{prep_data = TRUE}.}

\item{data}{A list of data produced by \code{prep_data} followed by \code{prep_data_cv}.}

\item{K}{An integer above 2, specifying the number of folds to use in the analysis. Defaults to 10.}

\item{chains}{A positive integer specifying the number of Markov chains to use for each model fit. Defaults to 2.}

\item{cores}{The number of cores to use when executing the Markov chains in parallel. Defaults to \code{parallel::detectCores(logical = FALSE)}. The function is parallelized so that users can specify a higher number of cores than chains and run chains for different folds simultaneously to save time.}

\item{warmup}{A positive integer specifying the number of warmup (aka burn-in) iterations per chain. If step-size adaptation is on (which it is by default), this also controls the number of iterations for which adaptation is run (and hence these warmup samples should not be used for inference). The number of warmup iterations should be smaller than \code{iter}.}

\item{iter}{A positive integer specifying the number of iterations for each chain (including warmup).}

\item{thin}{A positive integer specifying the period for saving samples.}

\item{control}{A named list of parameters to control the sampler's behavior. See the details in the documentation for the control argument in the \code{stan} function in the \code{rstan} package.}

\item{seed}{An integer passed on to \code{set.seed} before creating the folds to increase reproducibility and comparability. Defaults to 1 and only applies to fold-creation when the argument \code{prep_data} is \code{TRUE}. The supplied \code{seed} argument is also used to generate seeds for the sampling algorithm.}
}
\value{
A data frame containing the estimated ELPD and its standard error.
}
\description{
This function performs a K-fold cross-validation for an HBAM-type model in order to estimate the expected log pointwise predictive density for a new dataset (ELPD).
}
\examples{
\donttest{
# Loading and re-coding ANES 1980 data:
data(LC1980)
LC1980[LC1980 == 0 | LC1980 == 8 | LC1980 == 9] <- NA

# Making a small subset of the data for illustration:
self <- LC1980[1:50, 1]
stimuli <- LC1980[1:50, -1]

# Performing 10-fold cross-validation for the HBAM_MINI model:
  # NOTE: You normally want to use ALL cores for this, not just 2.
cv_hbam_mini <- hbam_cv(self, stimuli, model = "HBAM_MINI",
                        cores = 2, warmup = 500, iter = 1000)
}
}
