% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_stack.R
\name{tbl_stack}
\alias{tbl_stack}
\title{Stack tables}
\usage{
tbl_stack(tbls, group_header = NULL, quiet = FALSE)
}
\arguments{
\item{tbls}{(\code{list})\cr
List of gtsummary objects}

\item{group_header}{(\code{character})\cr
Character vector with table headers where length matches the length of \code{tbls}}

\item{quiet}{(scalar \code{logical})\cr
Logical indicating whether to suppress additional messaging. Default is \code{FALSE}.}
}
\value{
A \code{tbl_stack} object
}
\description{
Assists in patching together more complex tables. \code{tbl_stack()} appends two
or more gtsummary tables.
Column attributes, including number formatting and column footnotes, are
retained from the first passed gtsummary object.
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed("cardx", reference_pkg = "gtsummary") && gtsummary:::is_pkg_installed("survival", reference_pkg = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
# stacking two tbl_regression objects
t1 <-
  glm(response ~ trt, trial, family = binomial) \%>\%
  tbl_regression(
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (unadjusted)")
  )

t2 <-
  glm(response ~ trt + grade + stage + marker, trial, family = binomial) \%>\%
  tbl_regression(
    include = "trt",
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (adjusted)")
  )

tbl_stack(list(t1, t2))

# Example 2 ----------------------------------
# stacking two tbl_merge objects
library(survival)
t3 <-
  coxph(Surv(ttdeath, death) ~ trt, trial) \%>\%
  tbl_regression(
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (unadjusted)")
  )

t4 <-
  coxph(Surv(ttdeath, death) ~ trt + grade + stage + marker, trial) \%>\%
  tbl_regression(
    include = "trt",
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (adjusted)")
  )

# first merging, then stacking
row1 <- tbl_merge(list(t1, t3), tab_spanner = c("Tumor Response", "Death"))
row2 <- tbl_merge(list(t2, t4))

tbl_stack(list(row1, row2), group_header = c("Unadjusted Analysis", "Adjusted Analysis"))
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
